<?php

// جلوگیری از ارورهای متغیرهای تعریف نشده
if (!isset($text)) $text = null;
if (!isset($step)) $step = null;

// ==========================================
//           بخش بررسی عضویت اجباری
// ==========================================

// فقط اگر کاربر ادمین نیست این چک انجام شود (ادمین آزاد است)
if (!isAdmin($chat_id)) {
    
    // 1. بررسی اینکه آیا قابلیت در تنظیمات روشن است؟
    if (getSetting('force_join_active') == 'on') {
        
        // 2. دریافت لیست کانال‌های قفل شده از دیتابیس
        $lock_channels = getForceJoinChannels(); // تابع در functions.php

        if (!empty($lock_channels)) {
            $not_joined = [];

            // 3. چک کردن وضعیت عضویت کاربر در تک‌تک کانال‌ها
            foreach ($lock_channels as $ch) {
                // تابع isMember در functions.php
                if (!isMember($chat_id, $ch['chat_id'])) {
                    $not_joined[] = $ch;
                }
            }

            // 4. اگر لیستی از کانال‌هایی که عضو نیست وجود داشت
            if (!empty($not_joined)) {
                
                // اگر کاربر روی دکمه "عضو شدم" کلیک کرده ولی هنوز عضو نشده
                if (isset($update->callback_query) && $update->callback_query->data == 'check_join_lock') {
                    bot('answerCallbackQuery', [
                        'callback_query_id' => $update->callback_query->id,
                        'text' => "❌ شما هنوز در تمام کانال‌ها عضو نشده‌اید.\nلطفاً ابتدا عضو شوید سپس دکمه را بزنید.",
                        'show_alert' => true
                    ]);
                }

                // ساخت کیبورد شیشه‌ای شامل لینک کانال‌ها
                $keys = [];
                foreach ($not_joined as $ch) {
                    $keys[] = [['text' => "📢 عضویت در " . $ch['name'], 'url' => $ch['invite_link']]];
                }
                // دکمه بررسی مجدد در انتها
                $keys[] = [['text' => "✅ عضو شدم (بررسی مجدد)", 'callback_data' => "check_join_lock"]];

                $msg_text = "⛔️ **عضویت اجباری**\n\nکاربر گرامی، جهت استفاده از ربات لطفا ابتدا در کانال(های) زیر عضو شوید و سپس دکمه **«عضو شدم»** را لمس کنید:";

                // اگر پیام کال‌بک بود (کاربر دکمه‌های دیگر را زده)، فقط پیام هشدار بده
                if (isset($update->callback_query) && $update->callback_query->data != 'check_join_lock') {
                     bot('answerCallbackQuery', [
                        'callback_query_id' => $update->callback_query->id,
                        'text' => "🔒 برای استفاده از ربات باید در کانال‌ها عضو شوید.",
                        'show_alert' => true
                    ]);
                    // ارسال پیام قفل جدید
                    bot('sendMessage', [
                        'chat_id' => $chat_id,
                        'text' => $msg_text,
                        'parse_mode' => 'Markdown',
                        'reply_markup' => json_encode(['inline_keyboard' => $keys])
                    ]);
                } 
                // اگر پیام متنی یا استارت بود
                else {
                    bot('sendMessage', [
                        'chat_id' => $chat_id,
                        'text' => $msg_text,
                        'parse_mode' => 'Markdown',
                        'reply_markup' => json_encode(['inline_keyboard' => $keys])
                    ]);
                }

                // ⛔️ توقف کامل اجرای ربات در همین نقطه
                exit;
            } 
            
            // 5. اگر کاربر همه را عضو بود اما روی دکمه "عضو شدم" کلیک کرده بود (برای پاک کردن پیام قفل)
            elseif (isset($update->callback_query) && $update->callback_query->data == 'check_join_lock') {
                bot('answerCallbackQuery', [
                    'callback_query_id' => $update->callback_query->id,
                    'text' => "✅ عضویت شما تایید شد. خوش آمدید!",
                    'show_alert' => true
                ]);
                // حذف پیام قفل
                bot('deleteMessage', [
                    'chat_id' => $chat_id,
                    'message_id' => $update->callback_query->message->message_id
                ]);
                // توقف می‌کنیم تا تداخلی پیش نیاید (کاربر می‌تواند حالا با ربات کار کند)
                return;
            }
        }
    }
}
// ==========================================



// --- هندل کردن تایید اولیه پرداخت استارز ---
// --- هندل کردن تایید اولیه پرداخت استارز ---

checkAndDisableExpiredDiscount(); 

// ==========================================
//           بخش پاسخ به تیکت (ادمین)
// ==========================================
// اگر پیام از طرف ادمین است و روی پیامی ریپلای شده
if (isAdmin($chat_id) && isset($update->message->reply_to_message)) {
    $reply_msg_id = $update->message->reply_to_message->message_id;
    
    // پیدا کردن شناسه کاربر اصلی از روی دیتابیس تیکت‌ها
    // تابع getTicketOwnerByAdminMsgId باید در functions.php وجود داشته باشد
    $target_user_id = getTicketOwnerByAdminMsgId($reply_msg_id);

    if ($target_user_id) {
        // ارسال پیام ادمین به کاربر
        // از copyMessage استفاده می‌کنیم تا هر نوع فایلی (متن، عکس، ویس) پشتیبانی شود
        bot('copyMessage', [
            'chat_id' => $target_user_id,
            'from_chat_id' => ADMIN_ID,
            'message_id' => $message_id,
            'caption' => "👤 <b>پاسخ پشتیبانی:</b>\n\n" . ($text ?? ''), // اگر کپشن داشت اضافه کن
            'parse_mode' => 'HTML'
        ]);

        bot('sendMessage', [
            'chat_id' => ADMIN_ID,
            'text' => "✅ پاسخ شما برای کاربر ارسال شد.",
            'reply_to_message_id' => $message_id
        ]);
        exit; // جلوگیری از اجرای ادامه کدها برای ادمین
    }
}


// --- هندل کردن پرداخت موفق استارز ---
// --- هندل کردن پرداخت موفق استارز (اصلاح شده برای کوپن) ---
if (isset($update->message->successful_payment)) {
    $pay = $update->message->successful_payment;
    $payload = $pay->invoice_payload; // فرمت: prod_12 یا cpn_5_prod_12
    $amount = $pay->total_amount;
    
    $pid = 0;
    $coupon_id = null;

    // تشخیص اینکه آیا کوپن استفاده شده یا خیر
    if (strpos($payload, 'cpn_') === 0) {
        // فرمت: cpn_{id}_prod_{pid}
        if (preg_match('/cpn_(\d+)_prod_(\d+)/', $payload, $matches)) {
            $coupon_id = $matches[1];
            $pid = $matches[2];
            
            // افزایش شمارنده استفاده کوپن
            $db->pdo->prepare("UPDATE coupons SET used_count = used_count + 1 WHERE id = ?")->execute([$coupon_id]);
        }
    } else {
        // فرمت معمولی: prod_{pid}
        $pid = str_replace('prod_', '', $payload);
    }

    // ثبت سفارش (ستون coupon_id اضافه شد)
    $stmt = $db->pdo->prepare("INSERT INTO orders (user_id, product_id, amount, status, payment_method, coupon_id, created_at) VALUES (?, ?, ?, 'paid', 'stars', ?, NOW())");
    $stmt->execute([$chat_id, $pid, $amount, $coupon_id]);
    
    $oid = $db->pdo->lastInsertId();

    // --- ثبت استفاده کاربر از کد تخفیف (کد جدید) ---
    if ($coupon_id) {
        $db->pdo->prepare("INSERT INTO coupon_usage (user_id, coupon_id) VALUES (?, ?)")->execute([$chat_id, $coupon_id]);
    }


    // اطلاعات محصول
    $p_info = $db->pdo->prepare("SELECT title FROM products WHERE id = ?");
    $p_info->execute([$pid]);
    $p_title = $p_info->fetchColumn();

    // --- محاسبه تاریخ و زمان برای کاربر ---
    $g_date_user = date('Y-m-d');
    $time_user = date('H:i:s');
    list($gy_u, $gm_u, $gd_u) = explode('-', $g_date_user);
    $j_date_arr_u = gregorian_to_jalali($gy_u, $gm_u, $gd_u);
    $j_date_str_u = implode('/', $j_date_arr_u);

    // --- ساخت پیام حرفه‌ای کاربر ---
    $msg_user = "🎉 <b>تبریک! خرید شما با موفقیت انجام شد.</b>\n\n";
    $msg_user .= "🧾 <b>رسید دیجیتال سفارش:</b>\n";
    $msg_user .= "➖➖➖➖➖➖➖\n";
    $msg_user .= "📦 <b>محصول:</b> $p_title\n";
    $msg_user .= "⭐️ <b>مبلغ پرداختی:</b> $amount استارز\n";
    $msg_user .= "🔢 <b>شماره سفارش:</b> <code>$oid</code>\n";
    if($coupon_id) $msg_user .= "🎟 <b>کد تخفیف:</b> اعمال شد\n";
    $msg_user .= "📅 <b>تاریخ:</b> $j_date_str_u | ⏰ <b>ساعت:</b> $time_user\n";
    $msg_user .= "➖➖➖➖➖➖➖\n\n";
    $msg_user .= "📥 <b>نحوه دریافت فایل:</b>\n";
    $msg_user .= "محصول به حساب شما اضافه شد. جهت دانلود، همین الان روی دکمه <b>«📂 محصولات من»</b> در کیبورد پایین کلیک کنید.\n\n";
    $msg_user .= "🌹 <i>از اعتماد شما سپاسگزاریم.</i>";

    // پیام به کاربر
    bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => $msg_user,
        'parse_mode' => 'HTML',
        'reply_markup' => mainMenu($chat_id)
    ]);

    // پیام به ادمین
    $u = $update->message->from;
    $uname = isset($u->username) ? '@'.$u->username : 'ندارد';
    $name = htmlspecialchars($u->first_name);
    
    $stmt_u = $db->pdo->prepare("SELECT phone FROM users WHERE id = ?");
    $stmt_u->execute([$chat_id]);
    $u_phone_db = $stmt_u->fetchColumn();
    $phone_display = ($u_phone_db && !empty($u_phone_db)) ? $u_phone_db : 'ثبت نشده';

    $msg_admin = "🌟 **فروش جدید با استارز**\n\n";
    $msg_admin .= "👤 خریدار: $name\n🆔 آیدی: `$chat_id`\n🌐 یوزرنیم: $uname\n";
    $msg_admin .= "📱 شماره موبایل: $phone_display\n";
    $msg_admin .= "➖➖➖➖➖➖➖\n";
    $msg_admin .= "📦 محصول: $p_title\n💰 مبلغ: $amount استارز\n";
    if($coupon_id) $msg_admin .= "🎟 با کوپن تخفیف (ID: $coupon_id)\n";
    $msg_admin .= "🧾 شماره سفارش: `$oid`\n";
    $msg_admin .= "📅 تاریخ: $j_date_str_u\n⏰ ساعت: $time_user";

    // ارسال گزارش فروش به تمام ادمین‌های مجاز
    $admins = getAdminsForNotification('orders'); // یا همه ادمین‌ها
    if (empty($admins)) $admins = [ADMIN_ID]; // اطمینان از ارسال حداقل به مدیر اصلی

    foreach ($admins as $admin_chat_id) {
        bot('sendMessage', ['chat_id' => $admin_chat_id, 'text' => $msg_admin]);
    }
    exit;
}




// --- بررسی اجبار شماره موبایل ---
$force_phone = getSetting('force_phone_share');

// دریافت اطلاعات فعلی کاربر از دیتابیس برای بررسی شماره
$check_user = $db->pdo->prepare("SELECT phone FROM users WHERE id = ?");
$check_user->execute([$chat_id]);
$current_user_phone = $check_user->fetchColumn();

// اگر تنظیمات روشن است و کاربر شماره ندارد
if ($force_phone == 'on' && empty($current_user_phone)) {
    
    // اگر کاربر دکمه اشتراک‌گذاری را زده است (بررسی Contact)
    if (isset($update->message->contact)) {
        $contact = $update->message->contact;
        $contact_phone = $contact->phone_number;
        $contact_id = $contact->user_id;

        // 1. بررسی اینکه شماره متعلق به خود کاربر باشد
        if ($contact_id != $chat_id) {
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "⛔️ لطفاً فقط از دکمه پایین برای ارسال شماره خودتان استفاده کنید. ارسال شماره دیگران مجاز نیست."
            ]);
            exit;
        }

              // 2. بررسی محدودیت کشور (طبق تنظیمات پنل مدیریت)
        $restriction_mode = getSetting('phone_restriction_mode'); // دریافت تنظیمات (ir یا all)
        
        // استانداردسازی فرمت شماره (حذف + برای بررسی راحت‌تر)
        $clean_phone = str_replace('+', '', $contact_phone);

        // اگر تنظیمات روی 'ir' (فقط ایران) بود، پیش‌شماره را چک کن
        if ($restriction_mode == 'ir') {
            if (substr($clean_phone, 0, 2) !== '98') {
                 bot('sendMessage', [
                    'chat_id' => $chat_id,
                    'text' => "⛔️ متاسفانه طبق قوانین ربات، فقط شماره‌های ایران (+98) پذیرفته می‌شوند."
                ]);
                exit;
            }
        }
        // در غیر این صورت (حالت all)، کد بالا اجرا نشده و همه شماره‌ها پذیرفته می‌شوند.


        // اگر همه چیز درست بود، ذخیره در دیتابیس
        $stmt = $db->pdo->prepare("UPDATE users SET phone = ? WHERE id = ?");
        $stmt->execute([$contact_phone, $chat_id]);
        
        bot('sendMessage', [
            'chat_id' => $chat_id, 
            'text' => "✅ شماره موبایل شما با موفقیت تایید شد.\nاکنون می‌توانید از ربات استفاده کنید.",
            'reply_markup' => mainMenu($chat_id)
        ]);
        
        // ادامه نده تا پیام تکراری نیاید
        exit;

    } else {
        // اگر شماره ندارد و کانتکت هم نفرستاده، درخواست شماره کن و اجازه ادامه نده
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "👋 سلام کاربر گرامی،\n\n⚠️ برای استفاده از امکانات ربات، احراز هویت الزامی است.\n\nلطفاً با استفاده از دکمه زیر، شماره موبایل خود را تایید کنید:",
            'reply_markup' => json_encode([
                'keyboard' => [
                    [['text' => '📱 تایید شماره موبایل (کلیک کنید)', 'request_contact' => true]]
                ],
                'resize_keyboard' => true,
                'one_time_keyboard' => true
            ])
        ]);
        exit; // توقف کامل اجرای اسکریپت
    }
}

// user_panel.php

// --- دکمه ارسال تیکت (نسخه اصلاح شده برای Order ID) ---
if ($text == '📩 ارسال تیکت') {
    // دریافت لیست سفارش‌های موفق کاربر
    $purchased_orders = getUserPurchasedProductsList($chat_id);

    if (empty($purchased_orders)) {
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "❌ شما هنوز هیچ محصولی خریداری نکرده‌اید.\nبرای ارسال تیکت پشتیبانی، ابتدا باید محصول را خریداری کنید."
        ]);
    } else {
        $keys = [];
        foreach ($purchased_orders as $order) {
            // رفع خطا: استفاده از order_id به جای id
            $oid = $order['order_id']; 
            
            // فراخوانی تابع جدید با یک ورودی (آیدی سفارش)
            $status_info = checkSupportExpiry($oid);

            if ($status_info['allowed']) {
                $emoji = "✅";
                $status_text = "تا " . $status_info['expiry_date'];
            } else {
                $emoji = "❌";
                $status_text = "منقضی شده";
            }

            // متن دکمه: نام محصول | وضعیت تاریخ
            $btn_text = "🔸 " . $order['title'] . " ($emoji $status_text)";

            // ارسال order_id در کال‌بک دیتا
            $keys[] = [['text' => $btn_text, 'callback_data' => "ticket_prod_" . $oid]];
        }

        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "🎫 **ارسال تیکت پشتیبانی**\n\nلیست خریدهای شما به همراه تاریخ پایان پشتیبانی در زیر نمایش داده شده است.\nلطفاً سفارش مورد نظر را انتخاب کنید:",
            'parse_mode' => 'Markdown',
            'reply_markup' => json_encode(['inline_keyboard' => $keys])
        ]);
    }
}



// --- دریافت کد تخفیف از کاربر ---
if ($step == 'input_coupon_user' && $text != '🔙 انصراف') {
    // بازیابی ID محصول از تمپ دیتا
    $user = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
    $user->execute([$chat_id]);
    $temp = json_decode($user->fetchColumn(), true);
    $pid = $temp['pid']; // محصولی که قرار است تخفیف روی آن اعمال شود

    // بررسی صحت کد تخفیف
    $stmt = $db->pdo->prepare("SELECT * FROM coupons WHERE code = ?");
    $stmt->execute([$text]);
    $coupon = $stmt->fetch();

    $today = date('Y-m-d');

    if (!$coupon) {
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "❌ کد تخفیف وارد شده نامعتبر است.\nلطفاً مجدد تلاش کنید یا انصراف دهید."]);
    } elseif ($coupon['expiry_date'] < $today) {
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "❌ مهلت استفاده از این کد تخفیف به پایان رسیده است."]);
    } elseif ($coupon['usage_limit'] > 0 && $coupon['used_count'] >= $coupon['usage_limit']) {
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "❌ ظرفیت استفاده از این کد تخفیف تکمیل شده است."]);
    }
     // --- بررسی استفاده تکراری توسط کاربر (کد جدید) ---
    elseif ($db->pdo->query("SELECT id FROM coupon_usage WHERE user_id = '$chat_id' AND coupon_id = '{$coupon['id']}'")->rowCount() > 0) {
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "❌ شما قبلاً از این کد تخفیف استفاده کرده‌اید و مجاز به استفاده مجدد نیستید."]);
    }
    else {
        // --- کد معتبر است ---
        // محاسبه قیمت جدید و نمایش منوی خرید مخصوص کوپن
        
        $p_stmt = $db->pdo->prepare("SELECT * FROM products WHERE id = ?");
        $p_stmt->execute([$pid]);
        $product = $p_stmt->fetch();

        // تشخیص نوع ارز کوپن (تومان یا استارز)
        $currency_type = $coupon['target_currency']; // toman | stars
        $coupon_type = $coupon['type']; // percent | fixed
        $coupon_amount = $coupon['amount'];

        $msg = "✅ **کد تخفیف تایید شد!**\n\n";
        $keyboard = [];

        // اگر کوپن تومانی است
        if ($currency_type == 'toman') {
            $base_price = $product['price'];
            $new_price = $base_price;

            if ($coupon_type == 'percent') {
                $dec = $base_price * ($coupon_amount / 100);
                $new_price = $base_price - $dec;
            } else {
                $new_price = $base_price - $coupon_amount;
            }
            if ($new_price < 0) $new_price = 0;

            $msg .= "💰 قیمت اصلی: " . number_format($base_price) . " تومان\n";
            $msg .= "🎉 قیمت با کد تخفیف: **" . number_format($new_price) . " تومان**\n\n";
            $msg .= "👇 روش پرداخت را انتخاب کنید:";

            // دکمه‌های پرداخت تومانی با شناسه کوپن (_wcp)
            if (getSetting('online_payment_active') !== 'off') {
                $keyboard[] = [['text' => '🌐 پرداخت آنلاین (با تخفیف)', 'callback_data' => "pay_online_{$pid}_wcp_{$coupon['id']}"]];
            }
            if (getSetting('card_to_card_active') == 'on') {
                $keyboard[] = [['text' => '💳 کارت به کارت (با تخفیف)', 'callback_data' => "pay_card_{$pid}_wcp_{$coupon['id']}"]];
            }

        } 
        // اگر کوپن استارزی است
        elseif ($currency_type == 'stars') {
            $base_stars = $product['price_stars'];
                        // --- بررسی فعال بودن خرید استارز (کد جدید) ---
            if ($base_stars <= 0) {
                bot('sendMessage', [
                    'chat_id' => $chat_id,
                    'text' => "⛔️ امکان خرید با استارز برای این محصول فعال نیست، بنابراین نمی‌توانید از این کد تخفیف استفاده کنید."
                ]);
                exit;
            }
            // ----------------------------------------------

            $new_stars = $base_stars;

            if ($coupon_type == 'percent') {
                $dec = $base_stars * ($coupon_amount / 100);
                $new_stars = $base_stars - $dec;
            } else {
                $new_stars = $base_stars - $coupon_amount;
            }
            if ($new_stars < 1) $new_stars = 1; // استارز نمیتواند 0 باشد

            $msg .= "⭐️ قیمت اصلی: " . number_format($base_stars) . " استارز\n";
            $msg .= "🎉 قیمت با کد تخفیف: **" . number_format($new_stars) . " استارز**\n\n";
            $msg .= "👇 جهت پرداخت دکمه زیر را بزنید:";

            if (getSetting('stars_payment_active') == 'on') {
                $keyboard[] = [['text' => "⭐️ پرداخت $new_stars استارز", 'callback_data' => "pay_stars_{$pid}_wcp_{$coupon['id']}"]];
            }
        }

        $keyboard[] = [['text' => '🔙 انصراف', 'callback_data' => "view_$pid"]]; // بازگشت به محصول

        // ریست کردن استپ
              // ریست کردن استپ
        $db->pdo->prepare("UPDATE users SET step = 'none' WHERE id = ?")->execute([$chat_id]);

        // ========================================================
        // [شروع] خط جدید اضافه شده برای حل مشکل دکمه انصراف
        // این پیام باعث می‌شود دکمه انصراف حذف و منوی اصلی نمایش داده شود
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "🔄 به‌روزرسانی منو...",
            'reply_markup' => mainMenu($chat_id)
        ]);
        // [پایان] خط جدید
        // ========================================================

        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => $msg,
            'parse_mode' => 'Markdown',
            'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
        ]);

    }
}


// --- پردازش کد تخفیف وارد شده توسط کاربر ---
if ($step == 'input_coupon_user') {
    if ($text == '🔙 انصراف') {
        $db->pdo->prepare("UPDATE users SET step = 'none', temp_data = '{}' WHERE id = ?")->execute([$chat_id]);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "انصراف از اعمال کد تخفیف.", 'reply_markup' => mainMenu($chat_id)]);
    }
}



// --- دریافت فیش واریزی ---
if ($step == 'send_receipt' && !isset($update->callback_query)) {
    if ($text == '🔙 انصراف') {
        $db->pdo->prepare("UPDATE users SET step = 'none', temp_data = '{}' WHERE id = ?")->execute([$chat_id]);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "عملیات لغو شد.", 'reply_markup' => mainMenu($chat_id)]);
    } elseif (isset($message->photo)) {
        
        // بازیابی اطلاعات موقت
        $user = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
        $user->execute([$chat_id]);
        $temp = json_decode($user->fetchColumn(), true);
        $pid = $temp['pid'];
        $amount = $temp['amount'];
        $coupon_id = isset($temp['coupon_id']) ? $temp['coupon_id'] : null; // دریافت آیدی کوپن

        
        // دریافت اطلاعات محصول
        $stmt_p = $db->pdo->prepare("SELECT title FROM products WHERE id = ?");
        $stmt_p->execute([$pid]);
        $p_title = $stmt_p->fetchColumn();
        
        // دریافت اطلاعات کاربر
        $u_info = $db->pdo->prepare("SELECT * FROM users WHERE id = ?");
        $u_info->execute([$chat_id]);
        $user_row = $u_info->fetch();
        
               // ایمن‌سازی نام و یوزرنیم برای فرمت HTML
        $user_name = htmlspecialchars($user_row['name']);
        $user_phone = $user_row['phone'] ?: 'ندارد';
        // دریافت یوزرنیم و ایمن‌سازی آن (مهم: این خط باعث رفع باگ یوزرنیم‌های دارای آندرلاین می‌شود)
        $raw_username = isset($update->message->from->username) ? "@" . $update->message->from->username : 'ندارد';
        $username = htmlspecialchars($raw_username);
        // ایمن‌سازی نام محصول
        $safe_p_title = htmlspecialchars($p_title);

            // --- ثبت سفارش اصلاح شده (با متد card) ---
        $db->pdo->prepare("INSERT INTO orders (user_id, product_id, amount, status, coupon_id, payment_method, created_at) VALUES (?, ?, ?, 'pending_card', ?, 'card', NOW())")
               ->execute([$chat_id, $pid, $amount, $coupon_id]);

        $order_id = $db->pdo->lastInsertId();

        // ساخت کپشن با فرمت HTML (پایدار و بدون باگ کاراکتر خاص)
        $caption_admin = "🔔 <b>درخواست خرید کارت به کارت جدید</b>\n\n";
        $caption_admin .= "📦 محصول: $safe_p_title\n";
        $caption_admin .= "💰 مبلغ: " . number_format($amount) . " تومان\n";
        $caption_admin .= "👤 نام کاربر: $user_name\n";
        $caption_admin .= "🆔 شناسه عددی: <code>$chat_id</code>\n";
        $caption_admin .= "🌐 یوزرنیم: $username\n";
        $caption_admin .= "📱 موبایل: $user_phone\n";
        $caption_admin .= "🔢 شماره سفارش: <code>$order_id</code>\n\n";
        $caption_admin .= "لطفاً فیش را بررسی و تایید یا رد کنید:";

               // --- ارسال برای همه ادمین‌های بخش سفارشات ---
        $admins = getAdminsForNotification('orders'); 
        if (empty($admins)) $admins = [ADMIN_ID]; // اطمینان از ارسال حداقل به مدیر اصلی

        foreach ($admins as $admin_id) {
            bot('sendPhoto', [
                'chat_id' => $admin_id,
                'photo' => end($message->photo)->file_id,
                'caption' => $caption_admin,
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode([
                    'inline_keyboard' => [
                        [
                            ['text' => '✅ تایید پرداخت', 'callback_data' => "verify_card_$order_id"],
                            ['text' => '❌ رد پرداخت', 'callback_data' => "reject_card_$order_id"]
                        ]
                    ]
                ])
            ]);
        }


        
        // پیام موفقیت به کاربر
        $db->pdo->prepare("UPDATE users SET step = 'none', temp_data = '{}' WHERE id = ?")->execute([$chat_id]);
        bot('sendMessage', [
            'chat_id' => $chat_id, 
            'text' => "✅ فیش شما دریافت و برای مدیریت ارسال شد.\nنتیجه بررسی بزودی به شما اطلاع داده می‌شود.",
            'reply_markup' => mainMenu($chat_id)
        ]);
        
    } else {
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "لطفاً تصویر فیش واریزی را ارسال کنید."]);
    }
}

// --- دریافت پیام پشتیبانی (متن، عکس، فیلم و...) ---
if ($step == 'support_wait') {
    if ($text == '🔙 انصراف') {
        $db->pdo->prepare("UPDATE users SET step = 'none' WHERE id = ?")->execute([$chat_id]);
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "🔄 بازگشت به منوی اصلی.",
            'reply_markup' => mainMenu($chat_id)
        ]);
    } else {
        // دریافت اطلاعات کاربر از دیتابیس
        $u_stmt = $db->pdo->prepare("SELECT * FROM users WHERE id = ?");
        $u_stmt->execute([$chat_id]);
        $u_data = $u_stmt->fetch();
        
        // دریافت اطلاعات خام
        $raw_name = isset($u_data['name']) ? $u_data['name'] : 'کاربر';
        $phone_u = isset($u_data['phone']) ? $u_data['phone'] : 'ندارد';
        $raw_username = isset($update->message->from->username) ? '@' . $update->message->from->username : 'ندارد';

        // ✅ بخش جدید: ایمن‌سازی نام و یوزرنیم برای جلوگیری از تداخل با Markdown
        // تبدیل کاراکترهای خاص (_ * ` [) به فرمت متنی ساده
        $name_u = str_replace(['_', '*', '`', '['], ['\_', '\*', '\`', '\['], $raw_name);
        $username_u = str_replace(['_', '*', '`', '['], ['\_', '\*', '\`', '\['], $raw_username);

        // ساخت پیام برای ادمین (با فرمت Markdown)
        $info_msg = "📩 *پیام جدید پشتیبانی*\n\n";
        $info_msg .= "👤 نام: $name_u\n";
        $info_msg .= "🆔 آیدی: `$chat_id`\n";
        $info_msg .= "🌐 یوزرنیم: $username_u\n";
        $info_msg .= "📱 موبایل: $phone_u\n";
        $info_msg .= "🔻 محتوای پیام (فوروارد شده در پایین):";

                // --- ارسال برای همه ادمین‌های بخش پشتیبانی ---
        $support_admins = getAdminsForNotification('support');
        if (empty($support_admins)) $support_admins = [ADMIN_ID];

        foreach ($support_admins as $adm_id) {
            // 1. ارسال مشخصات کاربر
            bot('sendMessage', [
                'chat_id' => $adm_id,
                'text' => $info_msg,
                'parse_mode' => 'Markdown'
            ]);

            // 2. فوروارد پیام اصلی کاربر
            $fwd_res = bot('forwardMessage', [
                'chat_id' => $adm_id,
                'from_chat_id' => $chat_id,
                'message_id' => $message->message_id
            ]);

            // 3. ذخیره نگاشت پیام برای هر ادمین (تا هر کس ریپلای کرد کار کند)
            if (isset($fwd_res->result->message_id)) {
                $admin_msg_fwd_id = $fwd_res->result->message_id;
                // درج در جدول support_messages
                $db->pdo->prepare("INSERT INTO support_messages (user_id, admin_msg_id) VALUES (?, ?)")
                       ->execute([$chat_id, $admin_msg_fwd_id]);
            }
        }


        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "✅ پیام شما برای پشتیبانی ارسال شد.\nمنتظر پاسخ مدیریت باشید.",
        ]);
    }
}

// --- دریافت پیام تیکت مربوط به محصول (اصلاح شده: ارسال برای همه ادمین‌ها) ---
if ($step == 'sending_ticket') {
    if ($text == '🔙 انصراف') {
        $db->pdo->prepare("UPDATE users SET step = 'none', temp_data = '{}' WHERE id = ?")->execute([$chat_id]);
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "ارسال تیکت لغو شد. بازگشت به منوی اصلی.",
            'reply_markup' => mainMenu($chat_id)
        ]);
    } else {
        // 1. دریافت اطلاعات کاربر و دیتای موقت (برای پیدا کردن محصول)
        $u_stmt = $db->pdo->prepare("SELECT * FROM users WHERE id = ?");
        $u_stmt->execute([$chat_id]);
        $u_data = $u_stmt->fetch();
        
        $temp = json_decode($u_data['temp_data'], true);
        $prod_id = isset($temp['ticket_product_id']) ? $temp['ticket_product_id'] : 0;

        // 2. دریافت نام محصول
        $p_name = "محصول حذف شده";
        if ($prod_id > 0) {
            $p_stmt = $db->pdo->prepare("SELECT title FROM products WHERE id = ?");
            $p_stmt->execute([$prod_id]);
            $res = $p_stmt->fetchColumn();
            if ($res) $p_name = $res;
        }

        // 3. آماده‌سازی اطلاعات کاربر برای نمایش به ادمین
        $raw_name = isset($u_data['name']) ? $u_data['name'] : 'کاربر';
        $phone_u = isset($u_data['phone']) ? $u_data['phone'] : 'ندارد';
        $raw_username = isset($update->message->from->username) ? '@' . $update->message->from->username : 'ندارد';
        
        // ایمن‌سازی برای مارک‌داون
        $name_u = str_replace(['_', '*', '`', '['], ['\_', '\*', '\`', '\['], $raw_name);
        $username_u = str_replace(['_', '*', '`', '['], ['\_', '\*', '\`', '\['], $raw_username);
        $safe_p_name = str_replace(['_', '*', '`', '['], ['\_', '\*', '\`', '\['], $p_name);

        // 4. ساخت متن پیام برای ادمین
        $admin_msg = "🎫 *تیکت جدید (مربوط به محصول)*\n\n";
        $admin_msg .= "📦 محصول: *$safe_p_name*\n";
        $admin_msg .= "👤 فرستنده: $name_u\n";
        $admin_msg .= "🆔 آیدی: `$chat_id`\n";
        $admin_msg .= "🌐 یوزرنیم: $username_u\n";
        $admin_msg .= "📱 موبایل: $phone_u\n\n";
        $admin_msg .= "🔻 متن پیام کاربر (فوروارد شده در پایین):";

        // --- بخش اصلاح شده: ارسال برای لیست ادمین‌ها ---
        $support_admins = getAdminsForNotification('support');
        if (empty($support_admins)) $support_admins = [ADMIN_ID];

        foreach ($support_admins as $adm_id) {
            // الف) ارسال پیام متنی
            bot('sendMessage', [
                'chat_id' => $adm_id,
                'text' => $admin_msg,
                'parse_mode' => 'Markdown'
            ]);

            // ب) فوروارد پیام اصلی
            $fwd = bot('forwardMessage', [
                'chat_id' => $adm_id,
                'from_chat_id' => $chat_id,
                'message_id' => $message->message_id
            ]);

            // ج) ذخیره در دیتابیس برای پاسخدهی (برای هر ادمین جداگانه ثبت می‌شود)
            if (isset($fwd->result->message_id)) {
                $admin_msg_id = $fwd->result->message_id;
                $db->pdo->prepare("INSERT INTO support_messages (user_id, admin_msg_id) VALUES (?, ?)")
                       ->execute([$chat_id, $admin_msg_id]);
            }
        }
        // ---------------------------------------------

        // 5. پایان عملیات و پیام موفقیت به کاربر
        $db->pdo->prepare("UPDATE users SET step = 'none', temp_data = '{}' WHERE id = ?")->execute([$chat_id]);
        
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "✅ تیکت شما برای محصول **$p_name** ثبت شد.\nمنتظر پاسخ پشتیبانی بمانید.",
            'parse_mode' => 'Markdown',
            'reply_markup' => mainMenu($chat_id)
        ]);
    }
}


// --- حساب کاربری ---
if ($text == '👤 حساب کاربری') {
    $total_buy = $db->pdo->prepare("SELECT SUM(amount) FROM orders WHERE user_id = ? AND status = 'paid'");
    $total_buy->execute([$chat_id]);
    $sum = $total_buy->fetchColumn() ?: 0;
    
    $user_info = $db->pdo->prepare("SELECT * FROM users WHERE id = ?");
    $user_info->execute([$chat_id]);
    $u = $user_info->fetch();

    $msg = "👤 **حساب کاربری شما:**\n\n";
    $msg .= "🔖 نام: " . htmlspecialchars($u['name']) . "\n";
    $msg .= "🆔 شناسه: " . $chat_id . "\n";
    $msg .= "📱 موبایل: " . ($u['phone'] ?: 'ثبت نشده') . "\n";
    $msg .= "💰 مجموع خرید: " . number_format($sum) . " تومان";
    
    bot('sendMessage', ['chat_id' => $chat_id, 'text' => $msg, 'parse_mode' => 'Markdown']);
}

// --- تراکنش های من (نسخه پیشرفته با پشتیبانی از استارز) ---
elseif ($text == '🧾 تراکنش‌های من') {
    // دریافت ۱۰ تراکنش آخر کاربر
    $orders = $db->pdo->prepare("SELECT * FROM orders WHERE user_id = ? ORDER BY id DESC LIMIT 10");
    $orders->execute([$chat_id]);
    $list = $orders->fetchAll();
    
    if(!$list) {
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "📭 شما هنوز تراکنشی در فروشگاه نداشته‌اید."]);
    } else {
        $msg = "📋 **لیست ۱۰ تراکنش اخیر شما:**\n\n";
        
        foreach($list as $k => $o) {
            $row_num = $k + 1;
            
            // 1. دریافت نام محصول از جدول محصولات
            $stmt_p = $db->pdo->prepare("SELECT title FROM products WHERE id = ?");
            $stmt_p->execute([$o['product_id']]);
            $p_title = $stmt_p->fetchColumn();
            if (!$p_title) $p_title = "محصول حذف شده";

            // 2. تبدیل تاریخ میلادی دیتابیس به شمسی
            $created_parts = explode(' ', $o['created_at']);
            $date_only = $created_parts[0];
            $time_only = $created_parts[1];
            
            $d_ex = explode('-', $date_only);
            // استفاده از تابع موجود در functions.php
            $j_date = gregorian_to_jalali($d_ex[0], $d_ex[1], $d_ex[2]); 
            $date_show = implode('/', $j_date);

            // 3. تشخیص نوع ارز و روش پرداخت (استارز یا تومان)
            $pm = isset($o['payment_method']) ? $o['payment_method'] : 'zarinpal';
            $amount_show = "";
            $method_show = "";

            if ($pm == 'stars') {
                $amount_show = number_format($o['amount']) . " ⭐️ استارز";
                $method_show = "تلگرام استارز";
            } elseif ($pm == 'card') {
                $amount_show = number_format($o['amount']) . " تومان";
                $method_show = "کارت به کارت";
            } else {
                $amount_show = number_format($o['amount']) . " تومان";
                $method_show = "درگاه آنلاین";
            }

            // 4. تعیین وضعیت و آیکون
            $status_txt = ($o['status'] == 'paid') ? '✅ موفق' : '❌ ناموفق';
            
            // 5. کد پیگیری (اگر طولانی بود کوتاه می‌شود)
            $track_code = empty($o['authority']) ? '---' : substr($o['authority'], 0, 20);

            // ساخت متن پیام برای هر تراکنش
            $msg .= "$row_num. **$p_title**\n";
            $msg .= "💰 مبلغ: $amount_show\n";
            $msg .= "💳 روش: $method_show\n";
            $msg .= "📊 وضعیت: $status_txt\n";
            $msg .= "📅 تاریخ: $date_show | ⏰ $time_only\n";
            // فقط اگر کد پیگیری وجود داشت نمایش بده
           // if (!empty($o['authority']) && $o['authority'] != '0') {
             //   $msg .= "🧾 کد پیگیری: `$track_code`\n";
           // }
            $msg .= "➖➖➖➖➖➖➖➖\n";
        }
        
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => $msg,
            'parse_mode' => 'Markdown'
        ]);
    }
}

// --- محصولات من (دانلود) ---
elseif ($text == '📂 محصولات من') {
    $sql = "SELECT p.title, p.id FROM orders o JOIN products p ON o.product_id = p.id WHERE o.user_id = ? AND o.status = 'paid'";
    $stmt = $db->pdo->prepare($sql);
    $stmt->execute([$chat_id]);
    $prods = $stmt->fetchAll();

    if(!$prods) {
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "شما محصولی خریداری نکرده‌اید."]);
    } else {
        $keys = [];
        foreach($prods as $p) {
            $keys[] = [['text' => $p['title'], 'callback_data' => "myprod_" . $p['id']]];
        }
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "لیست محصولات خریداری شده. جهت دریافت فایل کلیک کنید:", 'reply_markup' => json_encode(['inline_keyboard' => $keys])]);
    }
}

// --- فروشگاه ---
elseif ($text == '🛍 فروشگاه') {
    $cats = $db->pdo->query("SELECT * FROM categories")->fetchAll();
    $keys = [];
    $keys[] = [['text' => '🔥 محبوب‌ترین محصولات', 'callback_data' => 'sort_popular']];
    $keys[] = [['text' => '🆕 جدیدترین محصولات', 'callback_data' => 'sort_new']];
    foreach($cats as $c) {
        $keys[] = [['text' => "📂 " . $c['name'], 'callback_data' => "cat_" . $c['id']]];
    }
    bot('sendMessage', ['chat_id' => $chat_id, 'text' => "به فروشگاه خوش آمدید. یک دسته بندی انتخاب کنید:", 'reply_markup' => json_encode(['inline_keyboard' => $keys])]);
}

// --- جستجو ---
elseif ($text == '🔍 جستجوی محصول') {
    $stmt = $db->pdo->prepare("UPDATE users SET step = 'search_prod' WHERE id = ?");
    $stmt->execute([$chat_id]);
    bot('sendMessage', [
        'chat_id' => $chat_id, 
        'text' => "⌨️ نام محصول مورد نظر (یا بخشی از آن) را وارد کنید:",
        'reply_markup' => json_encode([
            'keyboard' => [
                [['text' => '🔙 بازگشت به منوی اصلی']]
            ],
            'resize_keyboard' => true
        ])
    ]);
}
elseif ($step == 'search_prod') {
    if ($text == '🔙 بازگشت به منوی اصلی' || $text == '/start') {
        $db->pdo->prepare("UPDATE users SET step = 'none' WHERE id = ?")->execute([$chat_id]);
        bot('sendMessage', [
            'chat_id' => $chat_id, 
            'text' => "🔄 بازگشت به منوی اصلی.", 
            'reply_markup' => mainMenu($chat_id)
        ]);
    } else {
        // جستجو در عنوان و توضیحات (جستجوی دقیق‌تر)
        $stmt = $db->pdo->prepare("SELECT * FROM products WHERE title LIKE ? OR description LIKE ? LIMIT 10");
        $stmt->execute(["%$text%", "%$text%"]);
        $results = $stmt->fetchAll();
        
        if(!$results) {
            bot('sendMessage', [
                'chat_id' => $chat_id, 
                'text' => "❌ محصولی یافت نشد.\nلطفاً عبارت دیگری را امتحان کنید یا انصراف دهید."
            ]);
        } else {
            $keys = [];
            foreach($results as $r) {
                $keys[] = [['text' => $r['title'], 'callback_data' => "view_" . $r['id']]];
            }
            bot('sendMessage', [
                'chat_id' => $chat_id, 
                'text' => "🔎 نتایج جستجو برای: **$text**\nمورد نظر را انتخاب کنید:", 
                'parse_mode' => 'Markdown',
                'reply_markup' => json_encode(['inline_keyboard' => $keys])
            ]);
            
            // پایان استپ و بازگرداندن کیبورد اصلی
            $db->pdo->prepare("UPDATE users SET step = 'none' WHERE id = ?")->execute([$chat_id]);
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "جهت ادامه از منو استفاده کنید.",
                'reply_markup' => mainMenu($chat_id)
            ]);
        }
    }
}


// --- دکمه ارتباط با پشتیبانی ---
elseif ($text == '📞 ارتباط با پشتیبانی') {
    // تغییر استپ به حالت انتظار پیام
    $db->pdo->prepare("UPDATE users SET step = 'support_wait' WHERE id = ?")->execute([$chat_id]);
    
    bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "👨‍💻 **به بخش پشتیبانی خوش آمدید**\n\nلطفاً پیام خود را ارسال کنید (می‌توانید متن، عکس، ویدیو، ویس و... بفرستید).\nمدیریت در اسرع وقت پاسخ خواهد داد.\n\nجهت بازگشت، دکمه «🔙 انصراف» را بزنید.",
        'reply_markup' => json_encode([
            'keyboard' => [
                [['text' => '🔙 انصراف']]
            ],
            'resize_keyboard' => true
        ])
    ]);
}


// --- هندل کردن Callback Queries (دکمه شیشه‌ای) ---
if (isset($update->callback_query)) {
    // ==> اضافه شدن این خط برای بررسی خودکار انقضا قبل از هر کاری <==
    $data = $update->callback_query->data;
    $cq_id = $update->callback_query->id;
    $chat_id_cb = $update->callback_query->message->chat->id;

       // نمایش محصولات دسته (اصلاح شده برای پشتیبانی از چند دسته‌بندی)
    if (strpos($data, 'cat_') === 0) {
        $cat_id = str_replace('cat_', '', $data);
        
        // کوئری جدید: استفاده از JOIN برای خواندن از جدول واسط product_categories
        $sql = "SELECT p.* FROM products p 
                JOIN product_categories pc ON p.id = pc.product_id 
                WHERE pc.category_id = ?";
                
        $prods = $db->pdo->prepare($sql);
        $prods->execute([$cat_id]);
        $list = $prods->fetchAll();
        
        if (!$list) {
            bot('answerCallbackQuery', [
                'callback_query_id' => $cq_id,
                'text' => "❌ هیچ محصولی در این دسته یافت نشد.",
                'show_alert' => true
            ]);
        } else {
            $keys = [];
            foreach($list as $p) {
                $keys[] = [['text' => $p['title'], 'callback_data' => "view_" . $p['id']]];
            }
            
            bot('sendMessage', [
                'chat_id' => $chat_id_cb, 
                'text' => "📂 محصولات موجود در این دسته:", 
                'reply_markup' => json_encode(['inline_keyboard' => $keys])
            ]);
        }
    }

    

    
    // محبوب ترین و جدیدترین
    if ($data == 'sort_popular' || $data == 'sort_new') {
        $order = ($data == 'sort_new') ? "created_at DESC" : "views DESC";
        $prods = $db->pdo->query("SELECT * FROM products ORDER BY $order LIMIT 10")->fetchAll();
        $keys = [];
        foreach($prods as $p) $keys[] = [['text' => $p['title'], 'callback_data' => "view_" . $p['id']]];
        bot('sendMessage', ['chat_id' => $chat_id_cb, 'text' => "لیست محصولات:", 'reply_markup' => json_encode(['inline_keyboard' => $keys])]);
    }

    // نمایش تکی محصول
     // نمایش تکی محصول
    if (strpos($data, 'view_') === 0) {
        $pid = str_replace('view_', '', $data);

        // آپدیت بازدید
        $db->pdo->prepare("UPDATE products SET views = views + 1 WHERE id = ?")->execute([$pid]);

        $stmt = $db->pdo->prepare("SELECT * FROM products WHERE id = ?");
        $stmt->execute([$pid]);
        $p = $stmt->fetch();

        // دریافت تاریخ امروز
        $today = date('Y-m-d');

        // ایمن‌سازی متن‌ها برای HTML
        $safe_title = htmlspecialchars($p['title']);
        $safe_desc = htmlspecialchars($p['description']);

        // --- 1. بخش قیمت تومانی ---
              // --- 1. بخش قیمت تومانی (هوشمند با تخفیف سراسری) ---
        $price_text = "";
        if ($p['price'] > 0) {
            $original_price = $p['price'];
            $final_price_show = $original_price;
            $discount_active_show = false;
            $discount_expiry_show = "";

            // دریافت تنظیمات تخفیف سراسری
            $g_active = getSetting('global_discount_active');
            $g_expiry = getSetting('global_discount_expiry');
            $today = date('Y-m-d');

            // اولویت 1: بررسی فعال بودن تخفیف سراسری
            if ($g_active == 'on' && $g_expiry >= $today) {
                $g_type = getSetting('global_discount_type');
                $g_val = getSetting('global_discount_value');

                if ($g_type == 'percent') {
                    // محاسبه درصد
                    $dec_amount = $original_price * ($g_val / 100);
                    $final_price_show = $original_price - $dec_amount;
                } else {
                    // محاسبه مبلغ ثابت
                    $final_price_show = $original_price - $g_val;
                }
                
                // جلوگیری از منفی شدن قیمت
                if($final_price_show < 0) $final_price_show = 0;

                $discount_active_show = true;
                
                // تبدیل تاریخ انقضا سراسری به شمسی
                $ex_parts = explode('-', $g_expiry);
                $ja = gregorian_to_jalali($ex_parts[0], $ex_parts[1], $ex_parts[2]);
                $discount_expiry_show = "$ja[0]/$ja[1]/$ja[2]";

            } 
            // اولویت 2: اگر تخفیف سراسری نبود، تخفیف تکی محصول چک شود
            elseif ($p['discount_price'] > 0 && (empty($p['discount_expiry']) || $p['discount_expiry'] >= $today)) {
                $final_price_show = $p['discount_price'];
                $discount_active_show = true;
                
                // تبدیل تاریخ انقضا تکی به شمسی
                if (!empty($p['discount_expiry'])) {
                    $dt = explode('-', $p['discount_expiry']);
                    $ja = gregorian_to_jalali($dt[0], $dt[1], $dt[2]);
                    $discount_expiry_show = "$ja[0]/$ja[1]/$ja[2]";
                }
            }

            // ساخت متن نهایی قیمت
            if ($discount_active_show) {
                $price_text .= "💰 قیمت اصلی: <del>" . number_format($original_price) . "</del> تومان\n";
                $price_text .= "🎉 با تخفیف: <b>" . number_format($final_price_show) . "</b> تومان\n";
                if ($discount_expiry_show) {
                    $price_text .= "⏳ انقضای تخفیف: $discount_expiry_show\n";
                }
            } else {
                $price_text .= "💰 قیمت: " . number_format($original_price) . " تومان\n";
            }
        } else {
            $price_text .= "💰 قیمت: رایگان\n";
        }


        // --- 2. بخش قیمت استارز ---
        $stars_text = "";
        if (isset($p['price_stars']) && $p['price_stars'] > 0) {
            $stars_off_active = false;
            $stars_off_expiry_shamsi = "";

            if ($p['discount_price_stars'] > 0 && (empty($p['discount_expiry_stars']) || $p['discount_expiry_stars'] >= $today)) {
                $stars_off_active = true;
                if (!empty($p['discount_expiry_stars'])) {
                    $dt = explode('-', $p['discount_expiry_stars']);
                    $ja = gregorian_to_jalali($dt[0], $dt[1], $dt[2]);
                    $stars_off_expiry_shamsi = "$ja[0]/$ja[1]/$ja[2]";
                }
            }

            $stars_text .= "\n⭐️ ------------------ ⭐️\n";
            if ($stars_off_active) {
                $stars_text .= "⭐️ قیمت استارز: <del>" . number_format($p['price_stars']) . "</del>\n";
                $stars_text .= "🎁 با تخفیف: <b>" . number_format($p['discount_price_stars']) . "</b> استارز\n";
                if ($stars_off_expiry_shamsi) {
                    $stars_text .= "⏳ انقضای تخفیف استارز: $stars_off_expiry_shamsi\n";
                }
            } else {
                $stars_text .= "⭐️ قیمت استارز: " . number_format($p['price_stars']) . "\n";
            }
        }

        // --- 3. ساخت کپشن نهایی ---
        $caption = "📦 <b>" . $safe_title . "</b>\n\n";
        $caption .= $safe_desc . "\n\n";
        $caption .= "➖➖➖➖➖➖➖➖\n";
        $caption .= $price_text;
        $caption .= $stars_text;
        $caption .= "➖➖➖➖➖➖➖➖\n";
        
               // [تغییر جدید] شرط اضافه شد: && $p['support_days'] > 0
        if (getSetting('ticket_submission_active') == 'on' && $p['support_days'] > 0) {
            $caption .= "📅 پشتیبانی رایگان: " . $p['support_days'] . " روز\n";
        }

        
        $thumb_path = UPLOAD_DIR . $p['thumbnail'];

        // --- ساخت دکمه‌ها ---
                // --- ساخت دکمه‌ها ---
        $buttons = [];
        // ردیف اول: خرید + کد تخفیف
        $buttons[] = [
            ['text' => '💳 خرید و دانلود آنی', 'callback_data' => "buy_" . $pid],
            ['text' => '🎟 کد تخفیف دارم', 'callback_data' => "have_coupon_" . $pid] // دکمه جدید
        ];

        $row2 = [];
        $row2[] = ['text' => '🖼 گالری محصول', 'callback_data' => "gallery_" . $pid];

        if (!empty($p['preview_link'])) {
            $row2[] = ['text' => '🔗 پیش نمایش', 'url' => $p['preview_link']];
        }
        $buttons[] = $row2;

        // --- دکمه توضیحات بیشتر (در صورت وجود) ---
        if (!empty($p['more_description'])) {
            // یک ردیف جدید برای دکمه توضیحات بیشتر
            $buttons[] = [['text' => '📄 توضیحات بیشتر', 'callback_data' => "show_desc_" . $pid]];
        }


        // ارسال عکس با حالت HTML (مهم)
        bot('sendPhoto', [
            'chat_id' => $chat_id_cb,
            'photo' => new CURLFile($thumb_path),
   'caption' => $caption,
            'parse_mode' => 'HTML', // اینجا را تغییر دادیم
            'reply_markup' => json_encode(['inline_keyboard' => $buttons])
        ]);
    }
    

    // --- نمایش توضیحات بیشتر (More Description) ---
    if (strpos($data, 'show_desc_') === 0) {
        $pid = str_replace('show_desc_', '', $data);

        // دریافت توضیحات از دیتابیس
        $stmt = $db->pdo->prepare("SELECT more_description FROM products WHERE id = ?");
        $stmt->execute([$pid]);
        $full_desc = $stmt->fetchColumn();

        if (!empty($full_desc)) {
            // بستن لودینگ دکمه شیشه‌ای
            bot('answerCallbackQuery', [
                'callback_query_id' => $cq_id,
                'text' => '📄 در حال بارگذاری توضیحات...'
            ]);
            
            // ارسال متن طولانی با تابع هوشمند
            sendLongMessage($chat_id_cb, $full_desc);
        } else {
            bot('answerCallbackQuery', [
                'callback_query_id' => $cq_id,
                'text' => '❌ توضیحاتی ثبت نشده است.',
                'show_alert' => true
            ]);
        }
    }

    
        // --- نمایش گالری تصاویر (دکمه شیشه‌ای) ---
    if (strpos($data, 'gallery_') === 0) {
        $pid = str_replace('gallery_', '', $data);
        
        // دریافت لیست عکس‌ها از دیتابیس
        $gallery_stmt = $db->pdo->prepare("SELECT * FROM product_gallery WHERE product_id = ?");
        $gallery_stmt->execute([$pid]);
        $gallery_images = $gallery_stmt->fetchAll();

        if (!$gallery_images) {
            // اگر عکسی نبود، یک هشدار کوتاه نمایش بده (Alert)
            bot('answerCallbackQuery', [
                'callback_query_id' => $cq_id,
                'text' => '❌ تصویری در گالری این محصول وجود ندارد.',
                'show_alert' => true
            ]);
        } else {
            // اگر عکس بود، شروع به ارسال آلبوم کن
            bot('answerCallbackQuery', ['callback_query_id' => $cq_id, 'text' => '📥 در حال ارسال تصاویر...']);
            
            $media_group = [];
            $post_fields = [
                'chat_id' => $chat_id_cb,
            ];

            $i = 0;
            foreach ($gallery_images as $img) {
                $full_path = UPLOAD_DIR . $img['file_path'];
                
                if (file_exists($full_path)) {
                    $key = "photo_" . $i;
                    $media_group[] = [
                        'type' => 'photo',
                        'media' => "attach://$key"
                    ];
                    $post_fields[$key] = new CURLFile($full_path);
                    $i++;
                }
            }

            if (!empty($media_group)) {
                $post_fields['media'] = json_encode($media_group);
                bot('sendMediaGroup', $post_fields);
            } else {
                bot('sendMessage', ['chat_id' => $chat_id_cb, 'text' => "خطا: فایل‌های گالری در سرور پیدا نشدند."]);
            }
        }
    }


    // شروع خرید
       // انتخاب روش پرداخت
       if (strpos($data, 'buy_') === 0) {
        $pid = str_replace('buy_', '', $data);

        // چک کردن تنظیمات
        $c2c_active = getSetting('card_to_card_active');
        $stars_active = getSetting('stars_payment_active');

        $keyboard = [];
               // --- کد جدید: بررسی وضعیت پرداخت آنلاین ---
        // اگر در تنظیمات غیرفعال (off) نبود، دکمه را نشان بده
        if (getSetting('online_payment_active') !== 'off') {
            $keyboard[] = [['text' => '🌐 پرداخت آنلاین', 'callback_data' => "pay_online_" . $pid]];
        }


        // دکمه کارت به کارت
        if ($c2c_active == 'on') {
            $keyboard[] = [['text' => '💳 کارت به کارت', 'callback_data' => "pay_card_" . $pid]];
        }

        // دکمه استارز (اگر فعال باشد و قیمت داشته باشد)
        if ($stars_active == 'on') {
            $stmt = $db->pdo->prepare("SELECT price_stars, discount_price_stars, discount_expiry_stars FROM products WHERE id = ?");
            $stmt->execute([$pid]);
            $p = $stmt->fetch();
            
            // محاسبه قیمت
            $today = date('Y-m-d');
            $cost = $p['price_stars'];
            if ($p['discount_price_stars'] > 0 && (empty($p['discount_expiry_stars']) || $p['discount_expiry_stars'] >= $today)) {
                $cost = $p['discount_price_stars'];
            }

            if ($cost > 0) {
                $keyboard[] = [['text' => "⭐️ خرید با $cost استارز", 'callback_data' => "pay_stars_" . $pid]];
            }
        }

        bot('sendMessage', [
            'chat_id' => $chat_id_cb,
            'text' => "💳 روش پرداخت را انتخاب کنید:",
            'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
        ]);
    }


     // 1. پرداخت آنلاین (اصلاح شده)
    if (strpos($data, 'pay_online_') === 0) {
        // تشخیص حالت کوپن: pay_online_{pid}_wcp_{cid} یا pay_online_{pid}
        $pid = 0; $coupon_id = null; $is_wcp = false;
        
        if (strpos($data, '_wcp_') !== false) {
            $parts = explode('_wcp_', str_replace('pay_online_', '', $data));
            $pid = $parts[0];
            $coupon_id = $parts[1];
            $is_wcp = true;
        } else {
            $pid = str_replace('pay_online_', '', $data);
        }
        
        $stmt = $db->pdo->prepare("SELECT * FROM products WHERE id = ?");
        $stmt->execute([$pid]);
        $p = $stmt->fetch();
        
        $amount = $p['price'];

        // اگر کوپن بود
        if ($is_wcp && $coupon_id) {
            $c_stmt = $db->pdo->prepare("SELECT * FROM coupons WHERE id = ?");
            $c_stmt->execute([$coupon_id]);
            $cpn = $c_stmt->fetch();
            
            // اعمال تخفیف کوپن (اولویت مطلق)
            if ($cpn['type'] == 'percent') {
                $amount = $amount - ($amount * $cpn['amount'] / 100);
            } else {
                $amount = $amount - $cpn['amount'];
            }
        } else {
            // اعمال تخفیف‌های معمول (سراسری یا محصول)
            // ... (همان کدهای قبلی خودتان برای محاسبه قیمت معمولی) ...
            $today = date('Y-m-d');
            $g_active = getSetting('global_discount_active');
            $g_expiry = getSetting('global_discount_expiry');

            if ($g_active == 'on' && $g_expiry >= $today) {
                $g_type = getSetting('global_discount_type');
                $g_val = getSetting('global_discount_value');
                if ($g_type == 'percent') {
                    $amount = $amount - ($amount * ($g_val / 100));
                } else {
                    $amount = $amount - $g_val;
                }
            } elseif ($p['discount_price'] > 0 && (empty($p['discount_expiry']) || $p['discount_expiry'] >= $today)) {
                $amount = $p['discount_price'];
            }
        }
        
        if($amount < 0) $amount = 0; // جلوگیری از قیمت منفی

        // ادامه پروسه زرین پال (فقط اضافه کردن coupon_id به دیتابیس)
        // ... (کد زرین پال شما) ...
        // تغییر مهم: افزودن coupon_id به insert
        // توجه: کد زرین پال شما در فایل اصلی طولانی است، فقط قسمت Insert را تغییر دهید:
        
        // ... (بعد از دریافت result از زرین پال) ...
        // اینجا فرض میکنیم بقیه کدهای زرین پال کپی شده‌اند، فقط این خط تغییر میکند:
        /* 
           $db->pdo->prepare("INSERT INTO orders (user_id, product_id, amount, authority, coupon_id) VALUES (?, ?, ?, ?, ?)")
                   ->execute([$chat_id_cb, $pid, $amount, $authority, $coupon_id]);
        */
        // به دلیل طولانی بودن کد زرین پال، حتما در فایل خودتان این ستون coupon_id را اضافه کنید.
        
        // --- اینجا کد کامل اصلاح شده زرین پال برای راحتی شما ---
        $desc = "خرید محصول " . $p['title'];
        $callback = BASE_URL . "payment.php";
        $db_merchant = getSetting('zarinpal_merchant');
        $final_merchant_id = (!empty($db_merchant)) ? $db_merchant : ZARINPAL_MERCHANT_ID;
        
        $data_zp = [
            'merchant_id' => $final_merchant_id,
            'amount' => $amount * 10,
            'callback_url' => $callback,
            'description' => $desc,
        ];
        
        $ch = curl_init("https://api.zarinpal.com/pg/v4/payment/request.json");
        curl_setopt($ch, CURLOPT_USERAGENT, 'ZarinPal Rest Api v1');
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data_zp));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        $result = json_decode(curl_exec($ch));
        
        if (isset($result->data->code) && $result->data->code == 100) {
            $authority = $result->data->authority;
          
          // اصلاح شده: اضافه شدن ستون payment_method برای تفکیک در دیتابیس
$db->pdo->prepare("INSERT INTO orders (user_id, product_id, amount, authority, coupon_id, payment_method) VALUES (?, ?, ?, ?, ?, 'zarinpal')")
       ->execute([$chat_id_cb, $pid, $amount, $authority, $coupon_id]);

          
            $link = "https://www.zarinpal.com/pg/StartPay/" . $authority;
            bot('editMessageText', [
                'chat_id' => $chat_id_cb, 
                'message_id' => $update->callback_query->message->message_id,
                'text' => "فاکتور با مبلغ " . number_format($amount) . " تومان ایجاد شد.\nجهت پرداخت روی لینک زیر کلیک کنید:", 
                'reply_markup' => json_encode(['inline_keyboard' => [[['text' => 'لینک پرداخت', 'url' => $link]]]])
            ]);
        } else {
            bot('sendMessage', ['chat_id' => $chat_id_cb, 'text' => "خطا در اتصال به درگاه."]);
        }
    }

   



    // دانلود محصول خریداری شده
    if (strpos($data, 'myprod_') === 0) {
        $pid = str_replace('myprod_', '', $data);
        $files = $db->pdo->prepare("SELECT * FROM product_files WHERE product_id = ?");
        $files->execute([$pid]);
        $all_files = $files->fetchAll();

        bot('sendMessage', ['chat_id' => $chat_id_cb, 'text' => "📥 فایل‌های محصول:"]);
        
        foreach($all_files as $f) {
            $path = UPLOAD_DIR . $f['file_path'];
                       // بررسی وجود کپشن برای فایل
            // اگر در دیتابیس کپشن داشت، آن را نمایش می‌دهد، در غیر این صورت نام فایل را می‌گذارد
            $caption_text = (!empty($f['caption'])) ? $f['caption'] : $f['file_name'];

            bot('sendDocument', [
                'chat_id' => $chat_id_cb,
                'document' => new CURLFile($path),
                'caption' => $caption_text
            ]);

        }
        
        // --- دکمه پشتیبانی (اصلاح شده: اتصال به سیستم تیکت داخلی) ---
        // بجای لینک start=support، مستقیماً به پروسه انتخاب محصول برای تیکت وصل می‌شود
      //  bot('sendMessage', [
        //    'chat_id' => $chat_id_cb, 
        //    'text' => "در صورت وجود مشکل یا سوال در مورد این محصول، از دکمه زیر استفاده کنید:",
         //   'reply_markup' => json_encode(['inline_keyboard' => [[['text' => '📞 پشتیبانی محصول (ارسال تیکت)', 'callback_data' => "ticket_prod_" . $pid]]]])
       // ]);
    }
    
       // انتخاب محصول برای ارسال تیکت (اصلاح شده برای پشتیبانی بر اساس سفارش)
    if (strpos($data, 'ticket_prod_') === 0) {
        // در نسخه جدید، این مقدار برابر با Order ID است، نه Product ID
        $oid = str_replace('ticket_prod_', '', $data);
        
        // 1. بررسی وضعیت پشتیبانی برای این سفارش خاص
        // تابع checkSupportExpiry در functions.php اکنون با order_id کار می‌کند
        $support_status = checkSupportExpiry($oid);

        if ($support_status['allowed'] === false) {
            // اگر پشتیبانی تمام شده بود، پیام خطا (Alert) نمایش بده
            bot('answerCallbackQuery', [
                'callback_query_id' => $cq_id,
                'text' => $support_status['msg'], // متن خطای دقیق (تاریخ انقضا)
                'show_alert' => true
            ]);
            return; // توقف عملیات
        }

        // 2. دریافت آیدی محصول از روی آیدی سفارش (برای نمایش نام و ذخیره در تمپ)
        $stmt_order = $db->pdo->prepare("SELECT product_id FROM orders WHERE id = ?");
        $stmt_order->execute([$oid]);
        $pid = $stmt_order->fetchColumn();

        if (!$pid) {
            bot('answerCallbackQuery', [
                'callback_query_id' => $cq_id,
                'text' => '❌ خطای سیستمی: اطلاعات سفارش یافت نشد.',
                'show_alert' => true
            ]);
            return;
        }

        // 3. ذخیره اطلاعات در temp_data
        // ما ticket_product_id را ذخیره می‌کنیم تا استپ بعدی (sending_ticket) بدون تغییر کار کند
        // همچنین ticket_order_id را ذخیره می‌کنیم شاید در آینده لازم شود
        $db->pdo->prepare("UPDATE users SET step = 'sending_ticket', temp_data = ? WHERE id = ?")
               ->execute([json_encode([
                   'ticket_product_id' => $pid, 
                   'ticket_order_id' => $oid
               ]), $chat_id_cb]);

        // 4. دریافت نام محصول برای نمایش در پیام
        $p_name = getProductName($pid);

        // حذف پیام لیست دکمه‌ها برای تمیزی چت
        bot('deleteMessage', [
            'chat_id' => $chat_id_cb,
            'message_id' => $update->callback_query->message->message_id
        ]);

        // ارسال پیام درخواست متن تیکت
        bot('sendMessage', [
            'chat_id' => $chat_id_cb,
            'text' => "📝 شما در حال ارسال تیکت برای محصول: **$p_name** هستید.\n\n(سفارش شماره: `$oid`)\n\nلطفاً پیام خود را (متن، عکس، فیلم یا ویس) ارسال کنید:\n(برای لغو دکمه انصراف را بزنید)",
            'parse_mode' => 'Markdown',
            'reply_markup' => json_encode([
                'keyboard' => [[['text' => '🔙 انصراف']]],
                'resize_keyboard' => true
            ])
        ]);
    }

}

     // 3. پرداخت استارز (اصلاح شده)
    if (strpos($data, 'pay_stars_') === 0) {
        $pid = 0; $coupon_id = null; $is_wcp = false;
        if (strpos($data, '_wcp_') !== false) {
            $parts = explode('_wcp_', str_replace('pay_stars_', '', $data));
            $pid = $parts[0];
            $coupon_id = $parts[1];
            $is_wcp = true;
        } else {
            $pid = str_replace('pay_stars_', '', $data);
        }
        
        $stmt = $db->pdo->prepare("SELECT * FROM products WHERE id = ?");
        $stmt->execute([$pid]);
        $p = $stmt->fetch();

        $amount = $p['price_stars'];
        
        // محاسبه قیمت
        if ($is_wcp && $coupon_id) {
            $c_stmt = $db->pdo->prepare("SELECT * FROM coupons WHERE id = ?");
            $c_stmt->execute([$coupon_id]);
            $cpn = $c_stmt->fetch();
            if ($cpn['type'] == 'percent') {
                $amount = $amount - ($amount * $cpn['amount'] / 100);
            } else {
                $amount = $amount - $cpn['amount'];
            }
        } else {
            // منطق عادی
            $today = date('Y-m-d');
            if ($p['discount_price_stars'] > 0 && (empty($p['discount_expiry_stars']) || $p['discount_expiry_stars'] >= $today)) {
                 $amount = $p['discount_price_stars'];
            }
        }
        if($amount < 1) $amount = 1;

        // ساخت پی‌لود اختصاصی
        $payload = ($is_wcp) ? "cpn_{$coupon_id}_prod_{$pid}" : "prod_{$pid}";

        bot('sendInvoice', [
            'chat_id' => $chat_id_cb,
            'title' => $p['title'],
            'description' => "خرید محصول دیجیتال" . ($is_wcp ? " (با کد تخفیف)" : ""),
            'payload' => $payload, // پی‌لود جدید
            'currency' => 'XTR',
            'prices' => json_encode([['label' => 'قیمت نهایی', 'amount' => (int)$amount]]),
            'provider_token' => '',
            'start_parameter' => 'buy_stars'
        ]);
    }

    // --- درخواست وارد کردن کد تخفیف ---
    if (strpos($data, 'have_coupon_') === 0) {
        $pid = str_replace('have_coupon_', '', $data);
        
        // ذخیره محصول در تمپ و تغییر استپ
        $db->pdo->prepare("UPDATE users SET step = 'input_coupon_user', temp_data = ? WHERE id = ?")
               ->execute([json_encode(['pid' => $pid]), $chat_id_cb]);
        
        bot('sendMessage', [
            'chat_id' => $chat_id_cb,
            'text' => "🎟 لطفاً کد تخفیف خود را ارسال کنید:",
            'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 انصراف']]], 'resize_keyboard' => true])
        ]);
        
        // حذف پیام قبلی (اختیاری)
        bot('deleteMessage', ['chat_id' => $chat_id_cb, 'message_id' => $update->callback_query->message->message_id]);
    }

    // ==========================================
    // === تغییرات بخش پرداخت (پشتیبانی از _wcp) ===
    // ==========================================

    // --- تابع کمکی برای استخراج ID ها ---
    // این تکه کد نیازی به تابع بودن ندارد، فقط منطق آن در هر بخش استفاده می شود

  

      // --- پرداخت کارت به کارت (نسخه اصلاح شده با پشتیبانی کوپن) ---
    if (strpos($data, 'pay_card_') === 0) {
        $pid = 0; $coupon_id = null; $is_wcp = false;
        
        // تشخیص اینکه آیا کد تخفیف دارد یا خیر
        if (strpos($data, '_wcp_') !== false) {
            $parts = explode('_wcp_', str_replace('pay_card_', '', $data));
            $pid = $parts[0];
            $coupon_id = $parts[1];
            $is_wcp = true;
        } else {
            $pid = str_replace('pay_card_', '', $data);
        }

        // دریافت اطلاعات محصول
        $stmt = $db->pdo->prepare("SELECT * FROM products WHERE id = ?");
        $stmt->execute([$pid]);
        $p = $stmt->fetch();

        $final_price = $p['price'];

        // محاسبه قیمت
        if ($is_wcp && $coupon_id) {
            // اگر کوپن دارد: محاسبه بر اساس کوپن
            $c_stmt = $db->pdo->prepare("SELECT * FROM coupons WHERE id = ?");
            $c_stmt->execute([$coupon_id]);
            $cpn = $c_stmt->fetch();
            
            if ($cpn['type'] == 'percent') {
                $final_price = $final_price - ($final_price * $cpn['amount'] / 100);
            } else {
                $final_price = $final_price - $cpn['amount'];
            }
        } else {
             // اگر کوپن ندارد: محاسبه عادی (تخفیف سراسری یا تکی)
             $today = date('Y-m-d');
             $g_active = getSetting('global_discount_active');
             $g_expiry = getSetting('global_discount_expiry');

             if ($g_active == 'on' && $g_expiry >= $today) {
                 $g_type = getSetting('global_discount_type');
                 $g_val = getSetting('global_discount_value');

                 if ($g_type == 'percent') {
                     $dec = $final_price * ($g_val / 100);
                     $final_price = $final_price - $dec;
                 } else {
                     $final_price = $final_price - $g_val;
                 }
             } elseif ($p['discount_price'] > 0 && (empty($p['discount_expiry']) || $p['discount_expiry'] >= $today)) {
                 $final_price = $p['discount_price'];
             }
        }
        
        // جلوگیری از قیمت منفی
        if($final_price < 0) $final_price = 0;

        $card_num = getSetting('card_number');
        $card_name = getSetting('card_name');

        // چک کردن اینکه آیا اصلا کارتی ثبت شده است؟
        if(empty($card_num)) {
             bot('answerCallbackQuery', [
                'callback_query_id' => $cq_id,
                'text' => '⚠️ شماره کارتی توسط مدیریت ثبت نشده است.',
                'show_alert' => true
            ]);
            return; 
        }

        // ذخیره محصول و کوپن در تمپ و تغییر استپ
        $temp_array = ['pid' => $pid, 'amount' => $final_price];
        if($coupon_id) $temp_array['coupon_id'] = $coupon_id; // ذخیره شناسه کوپن

        $db->pdo->prepare("UPDATE users SET step = 'send_receipt', temp_data = ? WHERE id = ?")
               ->execute([json_encode($temp_array), $chat_id_cb]);

        $msg = "💳 **پرداخت کارت به کارت**\n\n";
        $msg .= "لطفاً مبلغ **" . number_format($final_price) . " تومان** را به شماره کارت زیر واریز کنید:\n\n";
        if($is_wcp) $msg .= "🎟 (مبلغ با احتساب کد تخفیف محاسبه شده است)\n\n";
        
        $msg .= "🔢 شماره کارت: `$card_num`\n";
        $msg .= "👤 به نام: $card_name\n\n";
        $msg .= "📸 پس از واریز، لطفاً عکس فیش (اسکرین‌شات) را همینجا ارسال کنید.\n";
        $msg .= "برای انصراف دکمه زیر را بزنید.";

        // حذف پیام قبلی و ارسال پیام جدید
        bot('deleteMessage', [
            'chat_id' => $chat_id_cb,
            'message_id' => $update->callback_query->message->message_id
        ]);

        bot('sendMessage', [
            'chat_id' => $chat_id_cb,
            'text' => $msg, 
            'parse_mode' => 'Markdown',
            'reply_markup' => json_encode([
                'keyboard' => [
                    [['text' => '🔙 انصراف']]
                ],
                'resize_keyboard' => true
            ])
        ]);
    }


  

?>
