<?php
// payment.php
require_once 'database.php';
require_once 'functions.php';

$Authority = $_GET['Authority'];
$Status = $_GET['Status'];

$stmt = $db->pdo->prepare("SELECT * FROM orders WHERE authority = ?");
$stmt->execute([$Authority]);
$order = $stmt->fetch();

// --- جلوگیری از ارسال پیام تکراری یا خطا ---
if ($order && $order['status'] == 'paid') {
    echo "<h1>این تراکنش قبلاً با موفقیت پرداخت و ثبت شده است.</h1>";
    exit;
}
// -------------------------------------------

if ($order) {
       if ($Status == 'OK') {
        // --- کد جدید: تعیین مرچنت کد (اولیت با دیتابیس) ---
        $db_merchant = getSetting('zarinpal_merchant');
        $final_merchant_id = (!empty($db_merchant)) ? $db_merchant : ZARINPAL_MERCHANT_ID;
        // ---------------------------------------------------

        $data = [
            'merchant_id' => $final_merchant_id,
            'authority' => $Authority,
            'amount' => $order['amount'] * 10
        ];

        
        $ch = curl_init("https://api.zarinpal.com/pg/v4/payment/verify.json");
        curl_setopt($ch, CURLOPT_USERAGENT, 'ZarinPal Rest Api v1');
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        $result = json_decode(curl_exec($ch));
        
        if (isset($result->data->code) && $result->data->code == 100) {
            // پرداخت موفق
            $db->pdo->prepare("UPDATE orders SET status = 'paid' WHERE id = ?")->execute([$order['id']]);
            
                        // [شروع] کد جدید برای حل مشکل محدودیت کد تخفیف
            if (!empty($order['coupon_id'])) {
                // 1. افزایش تعداد کل استفاده از کوپن
                $db->pdo->prepare("UPDATE coupons SET used_count = used_count + 1 WHERE id = ?")->execute([$order['coupon_id']]);
                
                // 2. ثبت اینکه این کاربر از این کوپن استفاده کرد (جلوگیری از استفاده مجدد)
                $db->pdo->prepare("INSERT INTO coupon_usage (user_id, coupon_id) VALUES (?, ?)")->execute([$order['user_id'], $order['coupon_id']]);
            }

            // اطلاع رسانی به کاربر
                     // --- شروع کد جدید گزارش دهی کامل به ادمین ---

            // 1. دریافت اطلاعات کامل محصول از دیتابیس
            $stmt_prod = $db->pdo->prepare("SELECT title FROM products WHERE id = ?");
            $stmt_prod->execute([$order['product_id']]);
            $prod_data = $stmt_prod->fetch();
            $product_title = $prod_data ? $prod_data['title'] : 'محصول نامشخص (حذف شده)';

            // 2. دریافت اطلاعات ذخیره شده کاربر در دیتابیس (برای شماره موبایل)
            $stmt_user = $db->pdo->prepare("SELECT name, phone FROM users WHERE id = ?");
            $stmt_user->execute([$order['user_id']]);
            $user_db = $stmt_user->fetch();

            // 3. دریافت اطلاعات زنده کاربر از تلگرام (برای نام، نام خانوادگی و یوزرنیم دقیق)
            $tg_user = bot('getChat', ['chat_id' => $order['user_id']]);
            
            // پردازش اطلاعات کاربر
            $u_first = isset($tg_user->result->first_name) ? $tg_user->result->first_name : ($user_db['name'] ?? 'ناشناس');
            $u_last = isset($tg_user->result->last_name) ? $tg_user->result->last_name : '';
            $full_name = trim($u_first . ' ' . $u_last);
            
            $username = (isset($tg_user->result->username)) ? '@' . $tg_user->result->username : 'ثبت نشده';
            $phone_number = (!empty($user_db['phone'])) ? $user_db['phone'] : 'ثبت نشده';

            // ساخت متن پیام گزارش
            $report_text = "💰 <b>گزارش تراکنش موفق (زرین‌پال)</b>\n\n";
            $report_text .= "📦 <b>محصول خریداری شده:</b>\n $product_title\n";
            $report_text .= "💵 <b>مبلغ:</b> " . number_format($order['amount']) . " تومان\n";
            $report_text .= "🧾 <b>کد پیگیری سفارش:</b> " . $order['id'] . "\n";
            $report_text .= "💳 <b>شناسه پرداخت (Authority):</b> \n<code>" . $Authority . "</code>\n\n";
            $report_text .= "👤 <b>مشخصات خریدار:</b>\n";
            $report_text .= "📛 <b>نام:</b> " . htmlspecialchars($full_name) . "\n";
            $report_text .= "🆔 <b>آیدی عددی:</b> <a href='tg://user?id=" . $order['user_id'] . "'>" . $order['user_id'] . "</a>\n";
            $report_text .= "🌐 <b>یوزرنیم:</b> " . $username . "\n";
            $report_text .= "📱 <b>تلفن همراه:</b> " . $phone_number . "\n";
            $report_text .= "⏰ <b>زمان:</b> " . date('Y/m/d H:i:s');

                      // --- ارسال گزارش به تمام ادمین‌های بخش سفارشات (اصلاح شده برای چند ادمینی) ---
            $admins = getAdminsForNotification('orders');
            if (empty($admins)) $admins = [ADMIN_ID]; // اطمینان از ارسال حداقل به مدیر اصلی

            foreach ($admins as $admin_id) {
                bot('sendMessage', [
                    'chat_id' => $admin_id,
                    'text' => $report_text,
                    'parse_mode' => 'HTML'
                ]);
            }


            // --- پایان کد جدید ---

            // --- شروع: ارسال پیام موفقیت به کاربر (کد جدید) ---
            $user_msg = "✅ <b>پرداخت شما با موفقیت انجام شد!</b>\n\n";
            $user_msg .= "🎉 کاربر گرامی، سفارش شما تایید شد و هم‌اکنون در حساب شما فعال است.\n\n";
            $user_msg .= "📦 <b>محصول خریداری شده:</b>\n $product_title\n";
            $user_msg .= "💰 <b>مبلغ پرداختی:</b> " . number_format($order['amount']) . " تومان\n";
            $user_msg .= "🧾 <b>کد رهگیری تراکنش:</b> <code>" . $order['id'] . "</code>\n\n";
            
            $user_msg .= "👇 <b>راهنمای دریافت محصول:</b>\n";
            $user_msg .= "برای دانلود فایل‌های این محصول، لطفا:\n";
            $user_msg .= "1️⃣ به ربات بازگردید.\n";
            $user_msg .= "2️⃣ از منوی اصلی، دکمه <b>«📂 محصولات من»</b> را انتخاب کنید.\n";
            $user_msg .= "3️⃣ فایل‌های مربوطه را دانلود نمایید.\n\n";
            
            $user_msg .= "🌹 با تشکر از خرید شما.";

            bot('sendMessage', [
                'chat_id' => $order['user_id'],
                'text' => $user_msg,
                'parse_mode' => 'HTML'
            ]);
            // --- پایان: ارسال پیام موفقیت به کاربر ---

            
            
            echo "<h1>پرداخت با موفقیت انجام شد. به ربات بازگردید.</h1>";
        } else {
                        // --- شروع: پیام خطای تایید به کاربر ---
            bot('sendMessage', [
                'chat_id' => $order['user_id'],
                'text' => "❌ <b>خطا در تراکنش!</b>\n\nکاربر گرامی، پرداخت شما توسط درگاه تایید نشد یا عملیات ناموفق بود.\nچنانچه مبلغی از حساب شما کسر شده است، معمولا تا ۷۲ ساعت آینده به حساب شما بازخواهد گشت.\n\nوضعیت سفارش: لغو شده",
                'parse_mode' => 'HTML'
            ]);
            // --- پایان: پیام خطا ---

            echo "<h1>خطا در تایید تراکنش.</h1>";
        }
    } else {
                // --- شروع: پیام لغو توسط کاربر ---
        bot('sendMessage', [
            'chat_id' => $order['user_id'],
            'text' => "⚠️ <b>تراکنش لغو شد</b>\n\nشما عملیات پرداخت را در درگاه بانکی لغو کردید یا پرداخت با خطا مواجه شد.\nسفارش شما انجام نشد.",
            'parse_mode' => 'HTML'
        ]);
        // --- پایان: پیام لغو ---

        echo "<h1>تراکنش توسط کاربر لغو شد.</h1>";
    }
} else {
    echo "<h1>سفارش یافت نشد.</h1>";
}
?>
