<?php
// fix_webhook.php
require_once 'config.php'; 

// آدرس دقیق ربات شما که از روی اسکرین‌شات برداشتم:
$webhook_url = "https://tutaplus.ir/telegram/birin-bot/index.php"; 

$url = "https://api.telegram.org/bot" . API_KEY . "/setWebhook";
$params = [
    'url' => $webhook_url,
    'allowed_updates' => json_encode([
        "message",
        "edited_message",
        "channel_post",
        "edited_channel_post",
        "inline_query",
        "chosen_inline_result",
        "callback_query",
        "shipping_query",
        "pre_checkout_query", // <<< کلید حل مشکل شما این خط است
        "poll",
        "poll_answer",
        "my_chat_member",
        "chat_member",
        "chat_join_request"
    ])
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$result = curl_exec($ch);
curl_close($ch);

echo "<h2>نتیجه درخواست به تلگرام:</h2>";
echo "<pre>" . $result . "</pre>";

if (strpos($result, '"ok":true') !== false) {
    echo "<h3 style='color:green'>✅ عالی شد! آپدیت‌های پرداخت فعال شدند.</h3>";
    echo "حالا بروید و در ربات دوباره دکمه خرید استارز را بزنید.";
} else {
    echo "<h3 style='color:red'>❌ خطا! لطفا فایل config.php را چک کنید که API_KEY درست باشد.</h3>";
}
?>
