<?php
// admin_panel.php
// تمام کدهای این فایل را پاک کنید و این کد را جایگزین کنید

if (isAdmin($chat_id)) {


    // --- حذف کانال عضویت اجباری (کال‌بک دکمه شیشه‌ای) ---
    // این بخش بررسی می‌کند که آیا ادمین روی دکمه حذف کلیک کرده است یا خیر
    if (isset($update->callback_query)) {
        $data = $update->callback_query->data;
        // بررسی پیشوند del_lock_
        if (strpos($data, 'del_lock_') === 0) {
            $id = str_replace('del_lock_', '', $data);
            
            // حذف از دیتابیس
            $stmt = $db->pdo->prepare("DELETE FROM force_join_channels WHERE id = ?");
            $stmt->execute([$id]);
            
            // نمایش پیام پاپ‌آپ موفقیت
            bot('answerCallbackQuery', [
                'callback_query_id' => $update->callback_query->id,
                'text' => "✅ کانال/گروه با موفقیت از لیست حذف شد.",
                'show_alert' => true
            ]);
            
            // حذف پیام دکمه‌دار برای تمیز شدن چت
            bot('deleteMessage', [
                'chat_id' => $chat_id,
                'message_id' => $update->callback_query->message->message_id
            ]);
            
            // توقف اجرای بقیه کدها چون این یک کال‌بک بود
            return; 
        }
    }


    // --- 📞 بخش پاسخ به پیام‌های پشتیبانی (ریپلای ادمین) ---
    if (isset($message->reply_to_message)) {
        // دریافت آیدی پیامی که ادمین روی آن ریپلای کرده
        $reply_id = $message->reply_to_message->message_id;

        // جستجوی صاحب اصلی پیام در دیتابیس
        $stmt = $db->pdo->prepare("SELECT user_id FROM support_messages WHERE admin_msg_id = ?");
        $stmt->execute([$reply_id]);
        $target_user_id = $stmt->fetchColumn();

        if ($target_user_id) {
            $send_data = ['chat_id' => $target_user_id];
            $method = 'sendMessage'; // پیش‌فرض

            // تشخیص نوع پیام ارسالی ادمین و آماده‌سازی داده‌ها
            if (isset($message->text)) {
                $method = 'sendMessage';
                $send_data['text'] = "👮‍♂️ <b>پاسخ پشتیبانی:</b>\n\n" . $message->text;
                $send_data['parse_mode'] = 'HTML';
            } elseif (isset($message->photo)) {
                $method = 'sendPhoto';
                $send_data['photo'] = end($message->photo)->file_id;
                if (isset($message->caption)) {
                    $send_data['caption'] = "👮‍♂️ <b>پاسخ پشتیبانی:</b>\n\n" . $message->caption;
                    $send_data['parse_mode'] = 'HTML';
                }
            } elseif (isset($message->video)) {
                $method = 'sendVideo';
                $send_data['video'] = $message->video->file_id;
                if (isset($message->caption)) {
                    $send_data['caption'] = "👮‍♂️ <b>پاسخ پشتیبانی:</b>\n\n" . $message->caption;
                    $send_data['parse_mode'] = 'HTML';
                }
            } elseif (isset($message->document)) {
                $method = 'sendDocument';
                $send_data['document'] = $message->document->file_id;
                if (isset($message->caption)) {
                    $send_data['caption'] = "👮‍♂️ <b>پاسخ پشتیبانی:</b>\n\n" . $message->caption;
                    $send_data['parse_mode'] = 'HTML';
                }
            } elseif (isset($message->voice)) {
                $method = 'sendVoice';
                $send_data['voice'] = $message->voice->file_id;
                if (isset($message->caption)) {
                    $send_data['caption'] = "👮‍♂️ <b>پاسخ پشتیبانی:</b>\n\n" . $message->caption;
                    $send_data['parse_mode'] = 'HTML';
                }
            } elseif (isset($message->audio)) {
                $method = 'sendAudio';
                $send_data['audio'] = $message->audio->file_id;
                if (isset($message->caption)) {
                    $send_data['caption'] = "👮‍♂️ <b>پاسخ پشتیبانی:</b>\n\n" . $message->caption;
                    $send_data['parse_mode'] = 'HTML';
                }
            } elseif (isset($message->sticker)) {
                $method = 'sendSticker';
                $send_data['sticker'] = $message->sticker->file_id;
            } else {
                bot('sendMessage', ['chat_id' => $chat_id, 'text' => "❌ فرمت پیام پشتیبانی ناشناخته است."]);
                return;
            }

            // ارسال پیام به کاربر
            $res = bot($method, $send_data);

            // اطلاع به ادمین از نتیجه ارسال
            if ($res->ok) {
                bot('sendMessage', [
                    'chat_id' => $chat_id,
                    'text' => "✅ پاسخ شما با موفقیت برای کاربر ارسال شد.",
                    'reply_to_message_id' => $message->message_id
                ]);
                                // --- ارسال اعلان به سایر مدیران ---
                $txt_for_notify = isset($message->text) ? $message->text : '(رسانه ارسال شد)';
                notifyAdminsOfReply($chat_id, $target_user_id, $txt_for_notify, 'support');
                // ----------------------------------

            } else {
                bot('sendMessage', [
                    'chat_id' => $chat_id,
                    'text' => "❌ خطا در ارسال پیام به کاربر. ممکن است کاربر ربات را بلاک کرده باشد.",
                    'reply_to_message_id' => $message->message_id
                ]);
            }
            
            // جلوگیری از اجرای ادامه کدها (چون این یک ریپلای بود نه دستور ربات)
            return;
        }
    }

// ==================================================
// 📨 بخش پاسخ به تیکت‌های محصول (Product Tickets)
// ==================================================

// بررسی می‌کنیم آیا ادمین روی پیامی ریپلای کرده است یا خیر
if (isset($update->message->reply_to_message)) {
    $reply_msg_id = $update->message->reply_to_message->message_id;

    // 1. بررسی در جدول تیکت‌های محصول
    // (تابع getTicketOwnerByAdminMsgId را قبلاً در functions.php اضافه کردیم)
    $ticket_data = getTicketOwnerByAdminMsgId($reply_msg_id);

    if ($ticket_data) {
        $target_user_id = $ticket_data['user_id'];
        $product_id = $ticket_data['product_id'];
        
        // گرفتن نام محصول جهت نمایش در پیام
        $prod_name = getProductName($product_id);

        // ارسال پاسخ ادمین برای کاربر
        bot('sendMessage', [
            'chat_id' => $target_user_id,
            'text' => "📩 **پاسخ پشتیبانی (محصول: $prod_name):**\n\n" . $text,
            'parse_mode' => 'Markdown',
            'reply_to_message_id' => $ticket_data['user_msg_id'] // ریپلای روی پیام اصلی کاربر (اختیاری)
        ]);

        // تایید ارسال برای ادمین
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "✅ پاسخ شما با موفقیت برای خریدار محصول ارسال شد.",
            'reply_to_message_id' => $message->message_id
        ]);
                // --- ارسال اعلان به سایر مدیران (بخش تیکت) ---
        notifyAdminsOfReply($chat_id, $target_user_id, $text, 'ticket');
        // ---------------------------------------------

        // توقف اجرا تا ربات دستورات دیگر را پردازش نکند
        return; 
    }
}
// ==================================================


    // --- ورود به پنل مدیریت ---
    if ($text == '⚙️ مدیریت ربات') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_home' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "به پنل مدیریت خوش آمدید.", 'reply_markup' => adminMenu()]);
    }

    // --- بازگشت ---
    elseif ($text == '🔙 بازگشت به منوی اصلی') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'none' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "منوی اصلی:", 'reply_markup' => mainMenu($chat_id)]);
    }

    // --- آمار فروشگاه (کامل و اصلاح شده) ---
    elseif ($text == '📊 آمار فروشگاه') {
        $s = getStoreStatistics();
        
        // ساخت پیام (تابع‌سازی شده برای جلوگیری از تکرار کد)
        $msg = generateStatsMessage($s);

        // کیبورد رفرش
        $keyboard = json_encode([
           'inline_keyboard' => [
                [['text' => '🔄 بروزرسانی آمار', 'callback_data' => 'refresh_stats']]
            ]
        ]);

        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => $msg,
            'parse_mode' => 'Markdown',
            'reply_markup' => $keyboard
        ]);
    }

    // --- هندل کردن دکمه بروزرسانی آمار ---
    elseif ($data == 'refresh_stats') {
        if ($chat_id == ADMIN_ID) {
            $s = getStoreStatistics();
            $msg = generateStatsMessage($s);
            $msg .= "\n🕒 آخرین بروزرسانی: " . date("H:i:s"); // اضافه کردن ساعت

$message_id = $update->callback_query->message->message_id;

            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => $msg,
                'parse_mode' => 'Markdown',
                'reply_markup' => json_encode([
                    'inline_keyboard' => [[['text' => '🔄 بروزرسانی آمار', 'callback_data' => 'refresh_stats']]]
                ])
            ]);
            
            bot('answerCallbackQuery', [
                'callback_query_id' => $update->callback_query->id,
                'text' => "✅ آمار بروز شد."
            ]);
        }
    }


    // --- هندل کردن دکمه بروزرسانی آمار (کال‌بک) ---
    elseif ($data == 'refresh_stats') {
        // چک کردن دسترسی ادمین
        if ($chat_id == ADMIN_ID) {
            $s = getStoreStatistics();

            // ساخت مجدد پیام (کپی از بالا)
            $msg = "📊 **گزارش پیشرفته فروشگاه**\n" . str_repeat("➖", 15) . "\n\n";
            $msg .= "👥 **آمار کاربران:**\n• آنلاین: `{$s['users_online']}` | فعال 24h: `{$s['users_active_24h']}`\n• کل کاربران: `{$s['users_total']}`\n\n";
            
            $msg .= "🛒 **فروش امروز:** `{$s['sales_today']}`\n";
            $msg .= "🛒 **فروش ماه:** `{$s['sales_month']}`\n\n";
            
            $msg .= "💰 **درآمد امروز:** `" . number_format($s['income_toman_today']) . "` تومان\n";
            $msg .= "💰 **درآمد کل:** `" . number_format($s['income_toman_total']) . "` تومان\n";
            
            if ($s['income_stars_total'] > 0) {
                $msg .= "\n⭐️ **درآمد استارز:** `{$s['income_stars_total']}`";
            }
            
            $msg .= "\n🕒 آخرین بروزرسانی: " . date("H:i:s");

            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => $msg,
                'parse_mode' => 'Markdown',
                'reply_markup' => json_encode([
                    'inline_keyboard' => [[['text' => '🔄 بروزرسانی آمار', 'callback_data' => 'refresh_stats']]]
                ])
            ]);
            
            // نمایش پیام کوتاه پاپ‌آپ
            bot('answerCallbackQuery', [
                'callback_query_id' => $update->callback_query->id,
                'text' => "✅ آمار بروز شد."
            ]);
        }
    }

        // --- تنظیمات فروشگاه (منوی اصلی) ---
    elseif ($text == '⚙️ تنظیمات فروشگاه' || $text == '🔙 بازگشت به تنظیمات فروشگاه') {
        // تغییر استپ نیاز نیست، فقط منو را نمایش میدهیم
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_store_settings' WHERE id = ?");
        $stmt->execute([$chat_id]);
        
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "⚙️ **تنظیمات فروشگاه**\n\nلطفاً یکی از بخش‌های زیر را انتخاب کنید:",
            'parse_mode' => 'Markdown',
            'reply_markup' => storeSettingsMenu() // این تابع در functions.php تعریف شده
        ]);
    }
    
        // ==================================================
    //           بخش مدیریت ادمین‌ها (Multi-Admin)
    // ==================================================

    // --- ورود به منوی مدیریت ادمین‌ها ---
    elseif ($text == '👤 مدیریت ادمین‌ها') {
        if (isConfigAdmin($chat_id)) {
            $db->pdo->prepare("UPDATE users SET step = 'admin_manage_admins' WHERE id = ?")->execute([$chat_id]);
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "👤 **پنل مدیریت مدیران ربات**\n\nدر این بخش می‌توانید مدیران جدیدی اضافه کنید که به پنل دسترسی داشته باشند.\n\n⚠️ **نکته:** مدیران جدید دسترسی کامل به پنل دارند اما نمی‌توانند مدیر دیگری اضافه یا حذف کنند.",
                'reply_markup' => adminManagementMenu()
            ]);
        } else {
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "⛔️ دسترسی غیرمجاز! فقط مدیر اصلی (Owner) به این بخش دسترسی دارد."]);
        }
    }

    // --- دکمه افزودن ادمین ---
    elseif ($text == '➕ افزودن ادمین') {
        if (isConfigAdmin($chat_id)) {
            $db->pdo->prepare("UPDATE users SET step = 'admin_add_new_admin_id' WHERE id = ?")->execute([$chat_id]);
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "✍️ لطفاً **آیدی عددی (User ID)** شخصی که می‌خواهید ادمین شود را ارسال کنید:\n\n(کاربر باید قبلاً ربات را استارت کرده باشد)",
                'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 بازگشت به مدیریت ادمین‌ها']]], 'resize_keyboard' => true])
            ]);
        }
    }

     // --- دکمه لیست ادمین‌ها ---
    elseif ($text == '👤 لیست ادمین‌ها') {
        if (isConfigAdmin($chat_id)) {
            $admins = getDBAdminsList();
            if ($admins) {
                $keys = [];
                foreach ($admins as $adm) {
                    $keys[] = [['text' => "🗑 حذف: " . htmlspecialchars($adm['name']) . " ({$adm['user_id']})", 'callback_data' => "del_admin_" . $adm['user_id']]];
                }
                bot('sendMessage', [
                    'chat_id' => $chat_id,
                    'text' => "📋 **لیست مدیران اضافه شده:**\n\nبرای حذف دسترسی، روی نام مدیر کلیک کنید:",
                    'reply_markup' => json_encode(['inline_keyboard' => $keys])
                ]);
            } else {
                bot('sendMessage', ['chat_id' => $chat_id, 'text' => "❌ هیچ مدیر جدیدی از طریق پنل اضافه نشده است."]);
            }
        }
    }

      // --- دکمه تنظیمات اعلان ---
    elseif ($text == '🔔 مدیریت نمایش اعلان و پیام‌ها') {
        if (isConfigAdmin($chat_id)) {
            $keys = [];
            // بررسی حالت فعلی
            $current_mode = getSetting('admin_notification_mode'); // 'all' or 'creator'
            
            $text_all = ($current_mode == 'all' || !$current_mode) ? "✅ ارسال برای همه" : "ارسال برای همه";
            $text_creator = ($current_mode == 'creator') ? "✅ فقط مدیر اصلی" : "فقط مدیر اصلی";

            $keys[] = [['text' => $text_all, 'callback_data' => "set_notif_mode_all"], ['text' => $text_creator, 'callback_data' => "set_notif_mode_creator"]];
            
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "🔔 **تنظیمات دریافت اعلان‌ها**\n\nمشخص کنید پیام‌های خرید، تیکت و... برای چه کسانی ارسال شود:\n\nوضعیت فعلی: " . ($current_mode == 'creator' ? 'فقط مدیر اصلی' : 'همه مدیران'),
                'reply_markup' => json_encode(['inline_keyboard' => $keys])
            ]);
        }
    }

    // --- بازگشت به مدیریت ادمین‌ها ---
    elseif ($text == '🔙 بازگشت به مدیریت ادمین‌ها') {
        if (isConfigAdmin($chat_id)) {
            $db->pdo->prepare("UPDATE users SET step = 'admin_manage_admins' WHERE id = ?")->execute([$chat_id]);
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "منوی مدیریت ادمین‌ها:", 'reply_markup' => adminManagementMenu()]);
        }
    }


    // --- مدیریت ارسال تیکت (منوی جدید) ---
    elseif ($text == '🎫 مدیریت ارسال تیکت') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_ticket_menu' WHERE id = ?");
        $stmt->execute([$chat_id]);
        
        $status = getSetting('ticket_submission_active') == 'on' ? '✅ فعال' : '❌ غیرفعال';
        
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "🎫 **مدیریت سیستم تیکت**\n\nوضعیت فعلی ارسال تیکت توسط کاربران: $status\n\nیک گزینه را انتخاب کنید:",
            'reply_markup' => json_encode([
                'keyboard' => [
                    [['text' => "وضعیت ارسال تیکت: $status"]],
                    [['text' => '⏳ تمدید تیکت']],
                    [['text' => '🔙 بازگشت به تنظیمات فروشگاه']]
                ],
                'resize_keyboard' => true
            ])
        ]);
    }
    
    // --- تغییر وضعیت ارسال تیکت ---
    elseif (strpos($text, 'وضعیت ارسال تیکت:') !== false) {
        $current = getSetting('ticket_submission_active');
        $new = ($current == 'on') ? 'off' : 'on';
        setSetting('ticket_submission_active', $new);
        
        $status_text = ($new == 'on') ? '✅ فعال' : '❌ غیرفعال';
        
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "✅ تنظیمات ذخیره شد.\nوضعیت جدید: $status_text",
            'reply_markup' => json_encode([
                'keyboard' => [
                    [['text' => "وضعیت ارسال تیکت: $status_text"]],
                    [['text' => '⏳ تمدید تیکت']],
                    [['text' => '🔙 بازگشت به تنظیمات فروشگاه']]
                ],
                'resize_keyboard' => true
            ])
        ]);
    }
    
    // --- شروع پروسه تمدید پشتیبانی ---
    elseif ($text == '⏳ تمدید تیکت') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_extend_search_user' WHERE id = ?");
        $stmt->execute([$chat_id]);
        
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "🔍 **تمدید پشتیبانی کاربر**\n\nلطفاً **آیدی عددی** یا **نام کاربری** (با @) کاربر مورد نظر را ارسال کنید:",
            'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 بازگشت به تنظیمات فروشگاه']]], 'resize_keyboard' => true])
        ]);
    }
    
    // --- دریافت یوزر برای تمدید (نمایش لیست خریدها) ---
    elseif ($step == 'admin_extend_search_user' && $text != '🔙 بازگشت به تنظیمات فروشگاه') {
        $user = searchUser($text); 
        
        if ($user) {
            // دریافت لیست محصولات خریداری شده
            $products = getUserPurchasedProductsList($user['id']); 
            
            if ($products) {
                $keys = [];
                foreach ($products as $p) {
                    // فرمت: select_ord_ORDERID
                    $keys[] = [['text' => "📦 " . $p['title'], 'callback_data' => "select_ord_" . $p['order_id']]];
                }
                
                bot('sendMessage', [
                    'chat_id' => $chat_id,
                    'text' => "👤 کاربر یافت شد: " . ($user['username'] ?? $user['id']) . "\n\n👇 **محصول مورد نظر برای تمدید پشتیبانی را انتخاب کنید:**",
                    'reply_markup' => json_encode(['inline_keyboard' => $keys])
                ]);
            } else {
                bot('sendMessage', ['chat_id' => $chat_id, 'text' => "❌ این کاربر هیچ محصول فعالی ندارد."]);
            }
        } else {
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "❌ کاربر یافت نشد. مجدد امتحان کنید."]);
        }
    }
    
    // --- دریافت تعداد روز تمدید و انجام عملیات ---
    elseif ($step == 'admin_extend_get_days') {
        if (is_numeric($text) && $text > 0) {
            // دریافت آیدی سفارش از temp_data
            $stmt = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
            $stmt->execute([$chat_id]);
            $temp = json_decode($stmt->fetchColumn(), true);
            $order_id = $temp['extend_order_id'];
            
            // انجام عملیات تمدید
            $res = extendOrderSupport($order_id, $text); 
            
            if ($res) {
                bot('sendMessage', [
                    'chat_id' => $chat_id,
                    'text' => "✅ **انجام شد!**\n\nپشتیبانی سفارش شماره `$order_id` به مدت $text روز تمدید شد.\nتاریخ انقضای جدید: " . $res['new_expiry'],
                    'parse_mode' => 'Markdown',
                    'reply_markup' => storeSettingsMenu()
                ]);
                
                // اطلاع به کاربر
                bot('sendMessage', [
                    'chat_id' => $res['user_id'],
                    'text' => "🎉 **پشتیبانی تمدید شد!**\n\nمدیریت پشتیبانی محصول **{$res['product_title']}** را برای شما تمدید کرد.\n📅 تاریخ انقضای جدید: {$res['new_expiry']}"
                ]);
                
                // ریست استپ
                $db->pdo->prepare("UPDATE users SET step = 'admin_store_settings', temp_data = '{}' WHERE id = ?")->execute([$chat_id]);
                
            } else {
                bot('sendMessage', ['chat_id' => $chat_id, 'text' => "❌ خطا در بروزرسانی دیتابیس."]);
            }
        } else {
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "لطفاً فقط عدد (به روز) وارد کنید:"]);
        }
    }


    // --- ارسال پیام همگانی (منوی اصلی) ---
    elseif ($text == '📢 ارسال پیام همگانی') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_broadcast_start' WHERE id = ?");
        $stmt->execute([$chat_id]);

        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "📢 **بخش ارسال پیام همگانی**\n\nلطفاً پیامی که می‌خواهید برای همه کاربران ارسال شود را همینجا بفرستید.\n\n🔹 **پشتیبانی کامل:** می‌توانید متن، عکس، ویدیو، وویس، آهنگ یا فایل بفرستید.\n🔹 **فروارد:** می‌توانید پیامی را از کانال خود فروارد کنید (در این صورت ویو پست برای کانال حساب می‌شود).",
            'parse_mode' => 'Markdown',
            'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 بازگشت به منوی اصلی']]], 'resize_keyboard' => true])
        ]);
    }

    // --- دریافت پیام برادکست و نمایش پیش‌نمایش ---
    elseif ($step == 'admin_broadcast_start' && $text != '🔙 بازگشت به منوی اصلی') {
        // تشخیص نوع پیام
        $msg_type = 'text';
        $file_id = '';
        $caption = '';
        $forward_msg_id = '';

        // ذخیره اطلاعات پیام در temp_data
        $temp = [];

        // اولویت با تشخیص فروارد است تا ویو حفظ شود
        if(isset($message->forward_from_chat) || isset($message->forward_from) || isset($message->forward_date)) {
            $msg_type = 'forward';
            // برای فروارد، ما آیدی همین پیامی که به ربات رسیده را نگه میداریم تا عیناً فروارد کنیم
            $temp['forward_msg_id'] = $message->message_id;
        }
        elseif (isset($message->photo)) {
            $msg_type = 'photo';
            $file_id = end($message->photo)->file_id;
            $caption = $message->caption ?? '';
        }
        elseif (isset($message->video)) {
            $msg_type = 'video';
            $file_id = $message->video->file_id;
            $caption = $message->caption ?? '';
        }
        elseif (isset($message->voice)) {
            $msg_type = 'voice';
            $file_id = $message->voice->file_id;
            $caption = $message->caption ?? '';
        }
        elseif (isset($message->audio)) {
            $msg_type = 'audio';
            $file_id = $message->audio->file_id;
            $caption = $message->caption ?? '';
        }
        elseif (isset($message->document)) {
            $msg_type = 'document';
            $file_id = $message->document->file_id;
            $caption = $message->caption ?? '';
        }
        elseif (isset($message->sticker)) {
            $msg_type = 'sticker';
            $file_id = $message->sticker->file_id;
        }
        elseif (isset($message->text)) {
            $msg_type = 'text';
            $caption = $message->text;
        } else {
             bot('sendMessage', ['chat_id' => $chat_id, 'text' => "❌ نوع پیام پشتیبانی نمی‌شود."]);
             return;
        }

        $temp['type'] = $msg_type;
        $temp['file_id'] = $file_id;
        $temp['caption'] = $caption;

        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_broadcast_confirm', temp_data = ? WHERE id = ?");
        $stmt->execute([json_encode($temp), $chat_id]);

        // نمایش پیش‌نمایش و دکمه تایید
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "✅ پیام شما دریافت شد.\n\nآیا از ارسال این پیام برای **همه کاربران** اطمینان دارید؟",
            'reply_to_message_id' => $message->message_id, // ریپلای روی پیام ادمین برای اطمینان
            'reply_markup' => json_encode([
                'keyboard' => [
                    [['text' => '✅ بله، ارسال شود']],
                    [['text' => '❌ خیر، لغو عملیات']]
                ],
                'resize_keyboard' => true
            ])
        ]);
    }

      // --- انجام عملیات ارسال (نسخه هوشمند و امن) ---
    elseif ($step == 'admin_broadcast_confirm' && $text == '✅ بله، ارسال شود') {
         // جلوگیری از قطع شدن اسکریپت در ارسال‌های طولانی
         set_time_limit(0);
         ignore_user_abort(true);

         $user_data = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
         $user_data->execute([$chat_id]);
         $temp = json_decode($user_data->fetchColumn(), true);

         // لیست کاربران
         $users_list = getAllUsersID();
         $total = count($users_list);

         // --- محاسبه هوشمند زمان و تاخیر ---
         // این توابع جدید در functions.php اضافه شدند
         $delay_micros = getSafeBroadcastDelay($total); // محاسبه تاخیر بر حسب میکروثانیه
         $est_time = estimateBroadcastTime($total); // تخمین زمان اتمام

         bot('sendMessage', [
             'chat_id' => $chat_id, 
             'text' => "🚀 **ارسال همگانی آغاز شد**\n\n👥 تعداد کاربران: $total نفر\n⏱ تخمین زمان ارسال: $est_time\n🐢 حالت امن: فعال (برای جلوگیری از بن شدن ربات)\n\nلطفاً تا دریافت پیام «پایان ارسال» صبر کنید..."
         ]);

         // ثبت شروع در دیتابیس
         $history_id = startBroadcastLog($chat_id, $temp['type'], $total);

         $success = 0;
         $failed = 0;

         foreach ($users_list as $uid) {
             $res = null;

             // ارسال بر اساس نوع پیام
             if ($temp['type'] == 'forward') {
                 $res = bot('forwardMessage', [
                     'chat_id' => $uid,
                     'from_chat_id' => $chat_id,
                     'message_id' => $temp['forward_msg_id']
                 ]);
             } elseif ($temp['type'] == 'text') {
                 $res = bot('sendMessage', ['chat_id' => $uid, 'text' => $temp['caption']]);
             } elseif ($temp['type'] == 'photo') {
                 $res = bot('sendPhoto', ['chat_id' => $uid, 'photo' => $temp['file_id'], 'caption' => $temp['caption']]);
             } elseif ($temp['type'] == 'video') {
                 $res = bot('sendVideo', ['chat_id' => $uid, 'video' => $temp['file_id'], 'caption' => $temp['caption']]);
             } elseif ($temp['type'] == 'voice') {
                 $res = bot('sendVoice', ['chat_id' => $uid, 'voice' => $temp['file_id'], 'caption' => $temp['caption']]);
             } elseif ($temp['type'] == 'audio') {
                 $res = bot('sendAudio', ['chat_id' => $uid, 'audio' => $temp['file_id'], 'caption' => $temp['caption']]);
             } elseif ($temp['type'] == 'document') {
                 $res = bot('sendDocument', ['chat_id' => $uid, 'document' => $temp['file_id'], 'caption' => $temp['caption']]);
             } elseif ($temp['type'] == 'sticker') {
                 $res = bot('sendSticker', ['chat_id' => $uid, 'sticker' => $temp['file_id']]);
             }

             if ($res && $res->ok) {
                 $success++;
             } else {
                 $failed++;
             }

             // --- تاخیر هوشمند ---
             usleep($delay_micros); 
         }

         // پایان و ثبت آمار نهایی
         endBroadcastLog($history_id, $success, $failed);

         // پاک کردن تمپ دیتا و بازگشت به منو
         $stmt = $db->pdo->prepare("UPDATE users SET step = 'none', temp_data = '{}' WHERE id = ?");
         $stmt->execute([$chat_id]);

         $report = "🏁 **پایان ارسال همگانی**\n\n";
         $report .= "👥 کل کاربران: $total\n";
         $report .= "✅ موفق: $success\n";
         $report .= "🚫 ناموفق: $failed\n\n";
         $report .= "🕒 تاریخچه در دیتابیس ذخیره شد.";

         bot('sendMessage', [
             'chat_id' => $chat_id,
             'text' => $report,
             'parse_mode' => 'Markdown',
             'reply_markup' => adminMenu()
         ]);
    }

    // --- لغو عملیات ارسال ---
    elseif ($step == 'admin_broadcast_confirm' && $text == '❌ خیر، لغو عملیات') {
         $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_home', temp_data = '{}' WHERE id = ?");
         $stmt->execute([$chat_id]);
         bot('sendMessage', [
             'chat_id' => $chat_id,
             'text' => "عملیات ارسال لغو شد.",
             'reply_markup' => adminMenu()
         ]);
    }


    // --- منوی تایید شماره موبایل ---
    elseif ($text == '📱 تایید شماره موبایل') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_phone_verification' WHERE id = ?");
        $stmt->execute([$chat_id]);

        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "📱 **مدیریت تایید شماره موبایل**\n\nدر این بخش می‌توانید قابلیت دریافت اجباری شماره موبایل از کاربران را مدیریت کنید.\n\nوضعیت فعلی دکمه در زیر نمایش داده شده است:",
            'parse_mode' => 'Markdown',
            'reply_markup' => phoneVerificationMenu() // این تابع در functions.php تعریف شده
        ]);
    }

    // --- دکمه تغییر وضعیت (روشن/خاموش کردن اشتراک گذاری) ---
    // از strpos استفاده می‌کنیم چون متن دکمه شامل ایموجی وضعیت است و تغییر می‌کند
    elseif (strpos($text, 'اشتراک گذاری شماره موبایل') !== false) {
        
        // دریافت وضعیت فعلی از دیتابیس
        $current_status = getSetting('force_phone_share');
        
        // تغییر وضعیت (اگر روشن بود خاموش شود و برعکس)
        $new_status = ($current_status == 'on') ? 'off' : 'on';
        setSetting('force_phone_share', $new_status);
        
        $status_msg = ($new_status == 'on') 
            ? "✅ قابلیت دریافت شماره موبایل **فعال** شد.\nکاربران جدید مجبور به ارسال شماره خواهند بود." 
            : "❌ قابلیت دریافت شماره موبایل **غیرفعال** شد.";

        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => $status_msg,
            'parse_mode' => 'Markdown',
            'reply_markup' => phoneVerificationMenu() // رفرش کردن دکمه شیشه‌ای
        ]);
    }

    // --- دکمه بازگشت از منوی تایید شماره به تنظیمات فروشگاه ---
    elseif ($text == '🔙 بازگشت به تنظیمات فروشگاه') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_store_settings' WHERE id = ?");
        $stmt->execute([$chat_id]);

        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "⚙️ بازگشت به منوی تنظیمات فروشگاه:",
            'reply_markup' => storeSettingsMenu()
        ]);
    }
    
        // ==========================================
    //           بخش مدیریت عضویت اجباری
    // ==========================================

    // --- ورود به منوی عضویت اجباری ---
    elseif ($text == '🔒 عضویت اجباری') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_force_join' WHERE id = ?");
        $stmt->execute([$chat_id]);
        
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "🔒 **مدیریت عضویت اجباری**\n\nدر این بخش می‌توانید کانال‌ها و گروه‌هایی که کاربران برای استفاده از ربات **مجبور به عضویت** در آن‌ها هستند را مدیریت کنید.\n\nوضعیت فعلی قفل در دکمه پایین نمایش داده شده است.",
            'parse_mode' => 'Markdown',
            'reply_markup' => forceJoinMenu() // تابع در functions.php تعریف شده
        ]);
    }

    // --- تغییر وضعیت فعال/غیرفعال بودن قفل ---
    elseif (strpos($text, 'وضعیت قفل:') !== false) {
        $current = getSetting('force_join_active');
        $new = ($current == 'on') ? 'off' : 'on';
        setSetting('force_join_active', $new);
        
        $msg = ($new == 'on') ? "✅ قابلیت عضویت اجباری **فعال** شد." : "❌ قابلیت عضویت اجباری **غیرفعال** شد.";
        bot('sendMessage', [
            'chat_id' => $chat_id, 
            'text' => $msg, 
            'parse_mode' => 'Markdown', 
            'reply_markup' => forceJoinMenu()
        ]);
    }

    // --- دکمه بازگشت از مدیریت قفل ---
    elseif ($text == '🔙 بازگشت به مدیریت قفل') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_force_join' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "منوی مدیریت عضویت اجباری:", 'reply_markup' => forceJoinMenu()]);
    }

    // --- دکمه مشاهده لیست ---
    elseif ($text == '📋 مشاهده لیست') {
        $channels = getForceJoinChannels(); // تابع در functions.php
        
        if (count($channels) == 0) {
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "📭 هیچ کانال یا گروهی برای عضویت اجباری ثبت نشده است."]);
        } else {
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "📋 **لیست کانال‌ها و گروه‌های قفل شده:**\nبرای حذف هر مورد، روی دکمه شیشه‌ای زیر آن کلیک کنید:", 'parse_mode' => 'Markdown']);
            
            foreach ($channels as $ch) {
                bot('sendMessage', [
                    'chat_id' => $chat_id,
                    'text' => "📢 **{$ch['name']}**\n🆔 ID: `{$ch['chat_id']}`\n🔗 [لینک عضویت]({$ch['invite_link']})",
                    'parse_mode' => 'Markdown',
                    'reply_markup' => json_encode([
                        'inline_keyboard' => [
                            [['text' => '🗑 حذف این مورد', 'callback_data' => "del_lock_{$ch['id']}"]]
                        ]
                    ])
                ]);
            }
        }
    }

    // --- دکمه افزودن کانال/گروه (شروع) ---
    elseif ($text == '➕ افزودن کانال/گروه') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_add_lock_start' WHERE id = ?");
        $stmt->execute([$chat_id]);
        
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "📝 برای افزودن، لطفاً **آیدی عددی** یا **یوزرنیم** کانال/گروه را ارسال کنید:\n\n🔹 مثال یوزرنیم: `@MyChannel`\n🔹 مثال آیدی: `-100123456789`\n\n⚠️ **نکته بسیار مهم:** ربات حتماً باید در کانال یا گروه مورد نظر **ادمین** باشد تا بتواند عضویت کاربران را چک کند.",
            'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 بازگشت به مدیریت قفل']]], 'resize_keyboard' => true])
        ]);
    }

    // --- پردازش افزودن کانال (دریافت آیدی) ---
    elseif ($step == 'admin_add_lock_start' && $text != '🔙 بازگشت به مدیریت قفل') {
        // بررسی اینکه آیا ربات در آن کانال دسترسی دارد یا خیر
        $res = bot('getChat', ['chat_id' => $text]);
        
        if (isset($res->ok) && $res->ok) {
            $chat_id_real = $res->result->id;
            $title = $res->result->title;
            $invite_link = '';

            // 1. تلاش برای پیدا کردن لینک دعوت (اگر عمومی باشد یا لینک داشته باشد)
            if (isset($res->result->username)) {
                $invite_link = "https://t.me/" . $res->result->username;
            } elseif (isset($res->result->invite_link)) {
                $invite_link = $res->result->invite_link;
            } else {
                // 2. اگر لینک نداشت (خصوصی بود)، ربات تلاش می‌کند لینک بسازد
                $export = bot('exportChatInviteLink', ['chat_id' => $chat_id_real]);
                if (isset($export->ok) && $export->ok) {
                    $invite_link = $export->result;
                }
            }

            if ($invite_link) {
                // ذخیره در دیتابیس
                $stmt = $db->pdo->prepare("INSERT INTO force_join_channels (chat_id, name, invite_link) VALUES (?, ?, ?)");
                $stmt->execute([$chat_id_real, $title, $invite_link]);
                
                // بازگشت به منو
                $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_force_join' WHERE id = ?");
                $stmt->execute([$chat_id]);
                
                // کاراکترهای خاص مارک‌داون را خنثی می‌کنیم تا پیام ارور ندهد
                $title_safe = str_replace(['_', '*', '`', '['], ['\_', '\*', '\`', '\['], $title);
                $link_safe = str_replace(['_', '*', '`', '['], ['\_', '\*', '\`', '\['], $invite_link);

                
                          bot('sendMessage', [
                'chat_id' => $chat_id,
                // در اینجا به جای $title از $title_safe و به جای $invite_link از $link_safe استفاده کردیم
                'text' => "✅ کانال/گروه **$title_safe** با موفقیت به لیست قفل اضافه شد.\n🔗 لینک ثبت شده: $link_safe",
                'parse_mode' => 'Markdown',
                'reply_markup' => forceJoinMenu()
            ]);

            } else {
                bot('sendMessage', ['chat_id' => $chat_id, 'text' => "⚠️ ربات به چت دسترسی دارد اما نتوانست لینک دعوت را پیدا یا ایجاد کند.\n\nلطفاً مطمئن شوید ربات در تنظیمات کانال/گروه دسترسی «Invite Users via Link» را دارد و مجدد تلاش کنید."]);
            }
        } else {
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "❌ ربات نتوانست چت مورد نظر را پیدا کند.\n\nدلایل احتمالی:\n1️⃣ ربات در آن کانال/گروه ادمین نیست.\n2️⃣ آیدی یا یوزرنیم اشتباه وارد شده است.\n\nلطفاً پس از ادمین کردن ربات، مجدد آیدی را ارسال کنید:"]);
        }
    }


    // --- منوی مدیریت تخفیف‌ها ---
    elseif ($text == '🎁 مدیریت تخفیف‌ها') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_discount_manage' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "🎁 **مدیریت تخفیف‌ها**\n\nلطفاً گزینه مورد نظر را انتخاب کنید:",
            'parse_mode' => 'Markdown',
            'reply_markup' => discountManagementMenu()
        ]);
    }

    // --- ورود به منوی مدیریت کدهای تخفیف ---
    elseif ($text == '🎟 مدیریت کدهای تخفیف') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_coupon_type_select' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "🎟 **مدیریت کدهای تخفیف**\n\nلطفاً نوع تخفیف را انتخاب کنید:",
            'reply_markup' => couponTypeMenu()
        ]);
    }

    // --- بازگشت به انتخاب نوع کد ---
    elseif ($text == '🔙 بازگشت به انتخاب نوع کد') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_coupon_type_select' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "بازگشت به منوی انتخاب نوع کد:",
            'reply_markup' => couponTypeMenu()
        ]);
    }

    // --- انتخاب تخفیف در قیمت اصلی ---
    elseif ($text == '💰 تخفیف در قیمت اصلی') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_coupon_toman_menu' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "💰 **مدیریت کدهای تخفیف (تومان)**",
            'reply_markup' => couponTomanMenu()
        ]);
    }

    // --- انتخاب تخفیف در قیمت استارز ---
    elseif ($text == '⭐️ تخفیف در قیمت استارز') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_coupon_stars_menu' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "⭐️ **مدیریت کدهای تخفیف (استارز)**",
            'reply_markup' => couponStarsMenu()
        ]);
    }

    // ==========================================
    //            بخش ایجاد کد تخفیف
    // ==========================================

    // --- شروع ایجاد کد (تومان یا استارز) ---
    elseif ($text == '➕ ایجاد کد تخفیف (تومان)' || $text == '➕ ایجاد کد تخفیف (استارز)') {
        $currency = ($text == '➕ ایجاد کد تخفیف (تومان)') ? 'toman' : 'stars';
        
        // ذخیره نوع ارز در تمپ دیتا
        $temp = ['coupon_currency' => $currency];
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_create_coupon_code', temp_data = ? WHERE id = ?");
        $stmt->execute([json_encode($temp), $chat_id]);

        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "📝 لطفاً **عبارت کد تخفیف** را وارد کنید (مثلاً: `OFF1404`):\n(فقط حروف انگلیسی و اعداد)",
            'parse_mode' => 'Markdown',
            'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 بازگشت به انتخاب نوع کد']]], 'resize_keyboard' => true])
        ]);
    }

    // --- دریافت کد تخفیف ---
    elseif ($step == 'admin_create_coupon_code' && $text != '🔙 بازگشت به انتخاب نوع کد') {
        // بررسی تکراری نبودن
        $check = $db->pdo->prepare("SELECT id FROM coupons WHERE code = ?");
        $check->execute([$text]);
        if ($check->rowCount() > 0) {
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "⛔️ این کد تخفیف قبلاً ثبت شده است. لطفاً کد دیگری وارد کنید:"]);
            return;
        }

        $user_data = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
        $user_data->execute([$chat_id]);
        $temp = json_decode($user_data->fetchColumn(), true);
        
        $temp['coupon_code'] = $text;
        
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_create_coupon_amount', temp_data = ? WHERE id = ?");
        $stmt->execute([json_encode($temp), $chat_id]);

        if ($temp['coupon_currency'] == 'toman') {
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "💲 **مقدار تخفیف** را تعیین کنید:\n\n1️⃣ برای درصدی: عدد + % (مثلا `20%`)\n2️⃣ برای مبلغ ثابت: عدد خالص به تومان (مثلا `50000`)",
                'parse_mode' => 'Markdown'
            ]);
        } else {
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "⭐️ تعداد **استارز** تخفیف را وارد کنید (فقط عدد):",
                'parse_mode' => 'Markdown'
            ]);
        }
    }

    // --- دریافت مقدار تخفیف ---
    elseif ($step == 'admin_create_coupon_amount' && $text != '🔙 بازگشت به انتخاب نوع کد') {
        $user_data = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
        $user_data->execute([$chat_id]);
        $temp = json_decode($user_data->fetchColumn(), true);

        $amount = 0;
        $type = 'fixed';

        if ($temp['coupon_currency'] == 'toman') {
            if (strpos($text, '%') !== false) {
                $type = 'percent';
                $amount = intval(str_replace('%', '', $text));
                if ($amount < 1 || $amount > 100) {
                    bot('sendMessage', ['chat_id' => $chat_id, 'text' => "❌ درصد باید بین 1 تا 100 باشد."]); return;
                }
            } elseif (is_numeric($text)) {
                $type = 'fixed';
                $amount = intval($text);
            } else {
                bot('sendMessage', ['chat_id' => $chat_id, 'text' => "❌ فرمت نامعتبر."]); return;
            }
        } else {
            // استارز
            if (!is_numeric($text)) {
                bot('sendMessage', ['chat_id' => $chat_id, 'text' => "❌ لطفاً عدد وارد کنید."]); return;
            }
            $amount = intval($text);
        }

        $temp['coupon_amount'] = $amount;
        $temp['coupon_type'] = $type;

        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_create_coupon_exp', temp_data = ? WHERE id = ?");
        $stmt->execute([json_encode($temp), $chat_id]);

        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "📅 **تاریخ انقضا** را به شمسی وارد کنید (مثال: `1404/12/29`):",
            'parse_mode' => 'Markdown'
        ]);
    }

    // --- دریافت تاریخ انقضا ---
    elseif ($step == 'admin_create_coupon_exp' && $text != '🔙 بازگشت به انتخاب نوع کد') {
        $parts = explode('/', $text);
        // تبدیل اعداد فارسی
        $parts = array_map(function($x){ return str_replace(['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'], ['0','1','2','3','4','5','6','7','8','9'], $x); }, $parts);

        if (count($parts) == 3 && checkdate($parts[1], $parts[2], $parts[0])) {
            $g_date_arr = jalali_to_gregorian($parts[0], $parts[1], $parts[2]);
            $g_date_str = implode('-', $g_date_arr);

            $user_data = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
            $user_data->execute([$chat_id]);
            $temp = json_decode($user_data->fetchColumn(), true);

            $temp['coupon_expiry'] = $g_date_str;

            $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_create_coupon_limit', temp_data = ? WHERE id = ?");
            $stmt->execute([json_encode($temp), $chat_id]);

            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "🔢 **محدودیت تعداد استفاده** را وارد کنید:\n\n(عدد `-1` را برای استفاده نامحدود وارد کنید)",
                'parse_mode' => 'Markdown'
            ]);
        } else {
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "❌ فرمت تاریخ اشتباه است. لطفا به صورت `1404/01/01` وارد کنید.", 'parse_mode' => 'Markdown']);
        }
    }

    // --- دریافت محدودیت و ذخیره نهایی ---
    elseif ($step == 'admin_create_coupon_limit' && $text != '🔙 بازگشت به انتخاب نوع کد') {
        if (!is_numeric($text) && $text != '-1') {
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "❌ لطفاً یک عدد معتبر وارد کنید."]); return;
        }

        $user_data = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
        $user_data->execute([$chat_id]);
        $temp = json_decode($user_data->fetchColumn(), true);

        $limit = intval($text);
        
        // ذخیره در دیتابیس
        $stmt = $db->pdo->prepare("INSERT INTO coupons (code, target_currency, type, amount, expiry_date, usage_limit, created_at) VALUES (?, ?, ?, ?, ?, ?, NOW())");
        $stmt->execute([
            $temp['coupon_code'],
            $temp['coupon_currency'],
            $temp['coupon_type'],
            $temp['coupon_amount'],
            $temp['coupon_expiry'],
            $limit
        ]);

        // بازگشت به منوی مربوطه
        $next_step = ($temp['coupon_currency'] == 'toman') ? 'admin_coupon_toman_menu' : 'admin_coupon_stars_menu';
        $menu = ($temp['coupon_currency'] == 'toman') ? couponTomanMenu() : couponStarsMenu();

        $db->pdo->prepare("UPDATE users SET step = ?, temp_data = '{}' WHERE id = ?")->execute([$next_step, $chat_id]);

        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "✅ کد تخفیف با موفقیت ایجاد شد.",
            'reply_markup' => $menu
        ]);
    }

    // ==========================================
    //            بخش لیست کدهای تخفیف
    // ==========================================

    elseif ($text == '📋 لیست کدهای تخفیف (تومان)' || $text == '📋 لیست کدهای تخفیف (استارز)') {
        $currency = ($text == '📋 لیست کدهای تخفیف (تومان)') ? 'toman' : 'stars';
        
        $stmt = $db->pdo->prepare("SELECT * FROM coupons WHERE target_currency = ? ORDER BY id DESC");
        $stmt->execute([$currency]);
        $coupons = $stmt->fetchAll();

        if (count($coupons) == 0) {
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "📭 هیچ کد تخفیفی یافت نشد."]);
        } else {
            foreach ($coupons as $c) {
                // تبدیل تاریخ انقضا به شمسی برای نمایش
                $exp_parts = explode('-', $c['expiry_date']);
                $j_date = gregorian_to_jalali($exp_parts[0], $exp_parts[1], $exp_parts[2]);
                $exp_shamsi = implode('/', $j_date);

                $val_display = ($c['type'] == 'percent') ? "{$c['amount']}%" : number_format($c['amount']) . (($c['target_currency']=='toman')?' تومان':' ⭐️');
                $limit_display = ($c['usage_limit'] == -1) ? "نامحدود" : $c['usage_limit'];
                $used_display = $c['used_count'];

                $msg = "🏷 **کد:** `{$c['code']}`\n";
                $msg .= "💰 مقدار: $val_display\n";
                $msg .= "📅 انقضا: $exp_shamsi\n";
                $msg .= "📊 استفاده: $used_display از $limit_display";

                bot('sendMessage', [
                    'chat_id' => $chat_id,
                    'text' => $msg,
                    'parse_mode' => 'Markdown',
                    'reply_markup' => json_encode([
                        'inline_keyboard' => [
                            [['text' => '🗑 حذف کد', 'callback_data' => "del_coupon_{$c['id']}"]]
                        ]
                    ])
                ]);
            }
        }
    }


    // --- بازگشت از مدیریت تخفیف‌ها به تنظیمات ---
    elseif ($text == '🔙 بازگشت به مدیریت تخفیف‌ها') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_discount_manage' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "🎁 بازگشت به منوی مدیریت تخفیف‌ها:",
            'reply_markup' => discountManagementMenu()
        ]);
    }

    // --- ورود به منوی تخفیف سراسری ---
    elseif ($text == '🌐 تخفیف سراسری') {
        checkAndDisableExpiredDiscount(); // <--- اضافه شدن بررسی خودکار انقضا
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_global_discount' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "🌐 **تنظیمات تخفیف سراسری**\n\nدر این بخش می‌توانید یک تخفیف کلی برای تمام محصولات اعمال کنید.\nنکته: این تخفیف جایگزین تخفیف‌های تکی محصولات خواهد شد.",
            'parse_mode' => 'Markdown',
            'reply_markup' => globalDiscountMenu()
        ]);
    }

    // --- تغییر وضعیت فعال/غیرفعال تخفیف سراسری ---
    elseif (strpos($text, 'وضعیت:') !== false && $step == 'admin_global_discount') {
        $current = getSetting('global_discount_active');
        $new = ($current == 'on') ? 'off' : 'on';
        setSetting('global_discount_active', $new);
        
        $msg = ($new == 'on') ? "✅ تخفیف سراسری فعال شد." : "❌ تخفیف سراسری غیرفعال شد.";
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => $msg, 'reply_markup' => globalDiscountMenu()]);
    }

    // --- درخواست مقدار تخفیف ---
    elseif ($text == '💲 تعیین مقدار تخفیف') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_set_global_val' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "💲 لطفاً مقدار تخفیف را وارد کنید:\n\n1️⃣ برای تخفیف درصدی، عدد را با علامت درصد وارد کنید (مثلا: `20%`)\n2️⃣ برای تخفیف مبلغی، فقط عدد را به تومان وارد کنید (مثلا: `50000`)\n\n👇 مقدار را ارسال کنید:",
            'parse_mode' => 'Markdown',
            'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 بازگشت به مدیریت تخفیف‌ها']]], 'resize_keyboard' => true])
        ]);
    }

    // --- ذخیره مقدار تخفیف ---
    elseif ($step == 'admin_set_global_val' && $text != '🔙 بازگشت به مدیریت تخفیف‌ها') {
        if (strpos($text, '%') !== false) {
            $val = intval(str_replace('%', '', $text));
            if($val > 100 || $val < 1) {
                bot('sendMessage', ['chat_id' => $chat_id, 'text' => "❌ درصد باید بین 1 تا 100 باشد."]);
            } else {
                setSetting('global_discount_type', 'percent');
                setSetting('global_discount_value', $val);
                $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_global_discount' WHERE id = ?");
                $stmt->execute([$chat_id]);
                bot('sendMessage', ['chat_id' => $chat_id, 'text' => "✅ تخفیف سراسری روی **$val درصد** تنظیم شد.", 'parse_mode' => 'Markdown', 'reply_markup' => globalDiscountMenu()]);
            }
        } elseif (is_numeric($text)) {
            setSetting('global_discount_type', 'fixed');
            setSetting('global_discount_value', $text);
            $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_global_discount' WHERE id = ?");
            $stmt->execute([$chat_id]);
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "✅ تخفیف سراسری روی **" . number_format($text) . " تومان** تنظیم شد.", 'parse_mode' => 'Markdown', 'reply_markup' => globalDiscountMenu()]);
        } else {
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "❌ فرمت نامعتبر است. لطفا عدد یا درصد وارد کنید."]);
        }
    }

    // --- درخواست تاریخ انقضا ---
    elseif ($text == '📅 تعیین تاریخ انقضا') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_set_global_exp' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "📅 لطفاً تاریخ انقضای تخفیف سراسری را به شمسی و با فرمت زیر وارد کنید:\n\n`1404/10/05`\n\n👇 تاریخ را ارسال کنید:",
            'parse_mode' => 'Markdown',
            'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 بازگشت به مدیریت تخفیف‌ها']]], 'resize_keyboard' => true])
        ]);
    }

    // --- ذخیره تاریخ انقضا ---
    elseif ($step == 'admin_set_global_exp' && $text != '🔙 بازگشت به مدیریت تخفیف‌ها') {
        $parts = explode('/', $text); // تبدیل اعداد فارسی به انگلیسی اگر کاربر فارسی تایپ کرد
        $parts = array_map(function($x){ 
            return str_replace(['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'], ['0','1','2','3','4','5','6','7','8','9'], $x);
        }, $parts);

        if (count($parts) == 3 && checkdate($parts[1], $parts[2], $parts[0])) { // checkdate expects M, D, Y technically implies Gregorian but works for simple validation check
            // تبدیل شمسی به میلادی
            $g_date_arr = jalali_to_gregorian($parts[0], $parts[1], $parts[2]);
            $g_date_str = implode('-', $g_date_arr); // YYYY-MM-DD

            setSetting('global_discount_expiry', $g_date_str);
            
            $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_global_discount' WHERE id = ?");
            $stmt->execute([$chat_id]);
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "✅ تاریخ انقضا روی **$text** تنظیم شد.", 'parse_mode' => 'Markdown', 'reply_markup' => globalDiscountMenu()]);
        } else {
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "❌ فرمت تاریخ اشتباه است. لطفا به صورت 1404/01/01 وارد کنید."]);
        }
    }

    // --- منوی روش‌های پرداخت ---
    elseif ($text == '💳 روش‌های پرداخت') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_payment_methods' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "💳 **مدیریت روش‌های پرداخت**\n\nلطفاً یک روش را انتخاب کنید:",
            'parse_mode' => 'Markdown',
            'reply_markup' => paymentMethodsMenu()
        ]);
    }

    // --- منوی کارت به کارت ---
    elseif ($text == '💳 کارت به کارت') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_card_settings' WHERE id = ?");
        $stmt->execute([$chat_id]);
        
        $card_num = getSetting('card_number') ?: 'ثبت نشده';
        $card_name = getSetting('card_name') ?: 'ثبت نشده';
        
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "💳 **تنظیمات کارت به کارت**\n\n🔢 شماره کارت فعلی: `$card_num`\n👤 صاحب کارت: $card_name\n\nگزینه مورد نظر را انتخاب کنید:",
            'parse_mode' => 'Markdown',
            'reply_markup' => cardToCardMenu()
        ]);
    }
    
    // --- تغییر وضعیت کارت به کارت (فعال/غیرفعال) ---
    elseif (strpos($text, 'وضعیت کارت به کارت:') !== false) {
        $current = getSetting('card_to_card_active');
        $new = ($current == 'on') ? 'off' : 'on';
        setSetting('card_to_card_active', $new);
        
        $msg = ($new == 'on') ? "✅ پرداخت کارت به کارت فعال شد." : "❌ پرداخت کارت به کارت غیرفعال شد.";
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => $msg, 'reply_markup' => cardToCardMenu()]);
    }
    
    // --- ثبت اطلاعات کارت ---
    elseif ($text == '📝 ثبت کارت جدید') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_set_card_num' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "🔢 لطفاً **شماره کارت** خود را ارسال کنید (فقط عدد):", 'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 انصراف']]], 'resize_keyboard' => true])]);
    }
        // --- ویرایش کارت (عملکرد مشابه ثبت کارت دارد) ---
    elseif ($text == '✏️ ویرایش کارت') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_set_card_num' WHERE id = ?");
        $stmt->execute([$chat_id]);
        
        $current_card = getSetting('card_number') ?: 'ثبت نشده';
        bot('sendMessage', [
            'chat_id' => $chat_id, 
            'text' => "شماره کارت فعلی: $current_card\n\n🔢 لطفاً **شماره کارت جدید** را ارسال کنید:", 
            'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 انصراف']]], 'resize_keyboard' => true])
        ]);
    }

    // --- حذف کارت ---
    elseif ($text == '🗑 حذف کارت') {
        setSetting('card_number', '');
        setSetting('card_name', '');
        bot('sendMessage', [
            'chat_id' => $chat_id, 
            'text' => "🗑 اطلاعات کارت بانکی با موفقیت حذف شد.", 
            'reply_markup' => cardToCardMenu()
        ]);
    }

    elseif ($step == 'admin_set_card_num' && $text != '🔙 انصراف') {
        setSetting('card_number', $text);
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_set_card_name' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "👤 حال **نام صاحب کارت** را وارد کنید:"]);
    }
    elseif ($step == 'admin_set_card_name') {
        setSetting('card_name', $text);
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_card_settings' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "✅ اطلاعات کارت با موفقیت ذخیره شد.", 'reply_markup' => cardToCardMenu()]);
    }

    // --- ورود به منوی پرداخت آنلاین ---
    elseif ($text == '🌐 پرداخت آنلاین') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_online_payment' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "🌐 **تنظیمات پرداخت آنلاین (زرین‌پال)**\n\nدر اینجا می‌توانید درگاه را فعال/غیرفعال کنید و یا کد مرچنت اختصاصی وارد کنید.", 'parse_mode' => 'Markdown', 'reply_markup' => onlinePaymentSettingsMenu()]);
    }

    // --- تغییر وضعیت فعال/غیرفعال پرداخت آنلاین ---
    elseif (strpos($text, 'وضعیت پرداخت آنلاین:') !== false) {
        $current = getSetting('online_payment_active');
        // اگر off بود بکنش on، در غیر این صورت (اگه on بود یا ست نشده بود) بکنش off
        $new = ($current == 'off') ? 'on' : 'off';
        setSetting('online_payment_active', $new);

        $msg = ($new == 'on') ? "✅ پرداخت آنلاین فعال شد." : "❌ پرداخت آنلاین غیرفعال شد.\nکاربران دیگر دکمه پرداخت آنلاین را نخواهند دید.";
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => $msg, 'reply_markup' => onlinePaymentSettingsMenu()]);
    }

    // --- مدیریت کد مرچنت ---
    elseif ($text == '🔑 مدیریت کد مرچنت') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_manage_merchant' WHERE id = ?");
        $stmt->execute([$chat_id]);
        
        $saved_merchant = getSetting('zarinpal_merchant');
        $config_merchant = ZARINPAL_MERCHANT_ID;
        
        $msg = "🔑 **مدیریت کد مرچنت زرین‌پال**\n\n";
        $msg .= "🔹 کد موجود در فایل کانفیگ: `$config_merchant`\n";
        $msg .= "🔸 کد اختصاصی ثبت شده در ربات: " . ($saved_merchant ? "`$saved_merchant`" : "*(ثبت نشده - استفاده از کانفیگ)*") . "\n\n";
        $msg .= "نکته: اگر کدی در ربات ثبت کنید، اولویت با کد ربات است.";
        
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => $msg, 'parse_mode' => 'Markdown', 'reply_markup' => merchantManageMenu()]);
    }

    // --- بازگشت به منوی پرداخت آنلاین از مدیریت مرچنت ---
    elseif ($text == '🔙 بازگشت به تنظیمات پرداخت آنلاین') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_online_payment' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "منوی تنظیمات پرداخت آنلاین:", 'reply_markup' => onlinePaymentSettingsMenu()]);
    }

    // --- درخواست ثبت مرچنت جدید ---
    elseif ($text == '📝 ثبت مرچنت جدید') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_set_merchant_code' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', [
            'chat_id' => $chat_id, 
            'text' => "📝 لطفاً **کد مرچنت ۳۶ رقمی** زرین‌پال خود را ارسال کنید:\nمثال: `xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx`", 
            'parse_mode' => 'Markdown',
            'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 انصراف']]], 'resize_keyboard' => true])
        ]);
    }

    // --- دریافت و ذخیره مرچنت کد ---
    elseif ($step == 'admin_set_merchant_code' && $text != '🔙 انصراف') {
        if (strlen($text) < 30) {
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "⚠️ فرمت کد مرچنت صحیح به نظر نمی‌رسد. لطفاً دوباره ارسال کنید یا انصراف دهید."]);
        } else {
            setSetting('zarinpal_merchant', trim($text));
            $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_manage_merchant' WHERE id = ?");
            $stmt->execute([$chat_id]);
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "✅ کد مرچنت اختصاصی با موفقیت ذخیره شد.", 'reply_markup' => merchantManageMenu()]);
        }
    }
    
    // --- انصراف از ثبت مرچنت ---
    elseif ($step == 'admin_set_merchant_code' && $text == '🔙 انصراف') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_manage_merchant' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "عملیات لغو شد.", 'reply_markup' => merchantManageMenu()]);
    }

    // --- حذف مرچنت اختصاصی ---
    elseif ($text == '🗑 حذف مرچنت اختصاصی') {
        setSetting('zarinpal_merchant', ''); // خالی کردن مقدار
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "🗑 کد مرچنت اختصاصی حذف شد.\nاز این پس از کد موجود در فایل `config.php` استفاده می‌شود.",
            'reply_markup' => merchantManageMenu()
        ]);
    }


    // --- بازگشت‌های منوهای جدید ---
    elseif ($text == '🔙 بازگشت به روش‌های پرداخت') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_payment_methods' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "منوی روش‌های پرداخت:", 'reply_markup' => paymentMethodsMenu()]);
    }
    
        // --- مدیریت روشن/خاموش کردن استارز ---
    elseif ($text == '⭐️ خرید با استارز') {
        $current = getSetting('stars_payment_active');
        $new_status = ($current == 'on') ? 'off' : 'on';
        setSetting('stars_payment_active', $new_status);
        
        $msg = ($new_status == 'on') ? "✅ پرداخت با استارز فعال شد." : "❌ پرداخت با استارز غیرفعال شد.";
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => $msg, 'reply_markup' => paymentMethodsMenu()]);
    }


    // --- لیست محصولات ---
    elseif ($text == '📦 لیست محصولات') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_list_products' WHERE id = ?");
        $stmt->execute([$chat_id]);

        $products = $db->pdo->query("SELECT id, title, price FROM products ORDER BY id DESC")->fetchAll();

        if (count($products) == 0) {
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "🚫 هنوز محصولی در فروشگاه ثبت نشده است."]);
        } else {
            $inline_keyboard = [];
                        // --- دکمه جستجو اضافه شده ---
            $inline_keyboard[] = [['text' => '🔍 جستجوی محصول', 'callback_data' => 'admin_search_prod']];
            // ---------------------------

            foreach ($products as $product) {
                $inline_keyboard[] = [
                    ['text' => "📦 " . $product['title'] . " (" . number_format($product['price']) . ")", 'callback_data' => "edit_prod_" . $product['id']]
                ];
            }
            
                        // --- دکمه جستجو در انتهای لیست (کد جدید) ---
            $inline_keyboard[] = [['text' => '🔍 جستجوی محصول', 'callback_data' => 'admin_search_prod']];


            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "📑 **لیست محصولات فروشگاه:**\n\nبرای مدیریت (ویرایش/حذف) روی نام محصول کلیک کنید:",
                'parse_mode' => 'Markdown',
                'reply_markup' => json_encode(['inline_keyboard' => $inline_keyboard])
            ]);
        }
    }
    // --- منطق جستجوی محصول (بخش پردازش متن) ---
    elseif ($step == 'admin_search_prod_wait') {
        // جستجو در دیتابیس بر اساس عنوان
        $stmt = $db->pdo->prepare("SELECT id, title, price FROM products WHERE title LIKE ? ORDER BY id DESC");
        $stmt->execute(["%$text%"]);
        $results = $stmt->fetchAll();

        if (!$results) {
             // اگر محصولی پیدا نشد
             $inline_keyboard = [[['text' => '🔙 بازگشت به لیست', 'callback_data' => 'back_to_list']]];
             bot('sendMessage', [
                 'chat_id' => $chat_id, 
                 'text' => "❌ محصولی با نام مشابه \"$text\" یافت نشد.",
                 'reply_markup' => json_encode(['inline_keyboard' => $inline_keyboard])
             ]);
        } else {
            // نمایش نتایج جستجو
            $inline_keyboard = [];
            foreach ($results as $product) {
                // استفاده از همان فرمت edit_prod_ برای استفاده از قابلیت‌های موجود ویرایش/حذف
                $inline_keyboard[] = [
                    ['text' => "📦 " . $product['title'] . " (" . number_format($product['price']) . ")", 'callback_data' => "edit_prod_" . $product['id']]
                ];
            }
            // دکمه بازگشت در انتهای نتایج
            $inline_keyboard[] = [['text' => '🔙 بازگشت به لیست', 'callback_data' => 'back_to_list']];

            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "🔍 نتایج جستجو برای: **$text**\n\nبرای مدیریت روی محصول کلیک کنید:",
                'parse_mode' => 'Markdown',
                'reply_markup' => json_encode(['inline_keyboard' => $inline_keyboard])
            ]);
        }
        
        // بازگشت به منوی اصلی ادمین برای جلوگیری از گیر کردن در لوپ، یا می‌توان استپ را نگه داشت
        // در اینجا استپ را به حالت خانه برمی‌گردانیم تا دستورات بعدی اجرا شوند
        $db->pdo->prepare("UPDATE users SET step = 'admin_home' WHERE id = ?")->execute([$chat_id]);
    }

    // --- مدیریت دسته بندی ---
      // --- مدیریت دسته بندی ---
    elseif ($text == '📂 دسته‌بندی‌ها') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_cat_menu' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "مدیریت دسته‌بندی‌ها. انتخاب کنید:",
            'reply_markup' => json_encode(['keyboard' => [[['text' => '➕ افزودن دسته'], ['text' => '📋 لیست دسته‌ها']], [['text' => '🔙 بازگشت به پنل']]], 'resize_keyboard' => true])
        ]);
    }

    elseif ($step == 'admin_cat_menu' && $text == '➕ افزودن دسته') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_add_cat' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "نام دسته‌بندی جدید را وارد کنید:"]);
    }
    elseif ($step == 'admin_add_cat') {
        $stmt = $db->pdo->prepare("INSERT INTO categories (name) VALUES (?)");
        $stmt->execute([$text]);
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_cat_menu' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "دسته‌بندی '$text' ایجاد شد."]);
    }
    
        elseif ($step == 'admin_cat_menu' && $text == '📋 لیست دسته‌ها') {
         $cats = $db->pdo->query("SELECT * FROM categories")->fetchAll();
         if (!$cats) {
             bot('sendMessage', ['chat_id' => $chat_id, 'text' => "هیچ دسته‌بندی وجود ندارد."]);
         } else {
             $keys = [];
             foreach($cats as $c) {
                 // هدایت به منوی مدیریت تکی دسته
                 $keys[] = [['text' => "📂 " . $c['name'], 'callback_data' => "manage_cat_" . $c['id']]];
             }
             bot('sendMessage', ['chat_id' => $chat_id, 'text' => "لیست دسته‌بندی‌ها:\nبرای ویرایش یا حذف، روی نام دسته کلیک کنید.", 'reply_markup' => json_encode(['inline_keyboard' => $keys])]);
         }
    }

    // --- ذخیره ویرایش نام دسته ---
    elseif ($step == 'admin_save_edit_cat') {
        $user = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
        $user->execute([$chat_id]);
        $cat_id = $user->fetchColumn(); // آی‌دی دسته در اینجا ذخیره شده بود

        if ($cat_id) {
            $stmt = $db->pdo->prepare("UPDATE categories SET name = ? WHERE id = ?");
            $stmt->execute([$text, $cat_id]);
            
            // بازگشت به منوی دسته‌ها
            $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_cat_menu', temp_data = '{}' WHERE id = ?");
            $stmt->execute([$chat_id]);
            
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "✅ نام دسته‌بندی با موفقیت به '$text' تغییر یافت."]);
        }
    }

    elseif ($text == '🔙 بازگشت به پنل') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_home' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "پنل مدیریت", 'reply_markup' => adminMenu()]);
    }

    // --- افزودن محصول ---
    elseif ($text == '➕ افزودن محصول') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'add_prod_title', temp_data = '{}' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "1️⃣ عنوان محصول را وارد کنید:", 'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 انصراف']]], 'resize_keyboard' => true])]);
    }
    elseif ($step == 'add_prod_title' && $text != '🔙 انصراف') {
        $temp = ['title' => $text];
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'add_prod_desc', temp_data = ? WHERE id = ?");
        $stmt->execute([json_encode($temp), $chat_id]);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "2️⃣ توضیحات محصول را وارد کنید:"]);
    }
    elseif ($step == 'add_prod_desc') {
        $user = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
        $user->execute([$chat_id]);
        $temp = json_decode($user->fetchColumn(), true);
        $temp['desc'] = $text;

        $stmt = $db->pdo->prepare("UPDATE users SET step = 'add_prod_thumb', temp_data = ? WHERE id = ?");
        $stmt->execute([json_encode($temp), $chat_id]);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "3️⃣ تصویر شاخص محصول را ارسال کنید (فقط عکس):"]);
    }
    elseif ($step == 'add_prod_thumb') {
        if (isset($message->photo)) {
            $photo = end($message->photo);
            $file_path = saveFile($photo->file_id, 'thumbnails');

            $user = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
            $user->execute([$chat_id]);
            $temp = json_decode($user->fetchColumn(), true);
            $temp['thumb'] = $file_path;

            $stmt = $db->pdo->prepare("UPDATE users SET step = 'add_prod_gallery', temp_data = ? WHERE id = ?");
            $stmt->execute([json_encode($temp), $chat_id]);
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "4️⃣ فایل‌های گالری (عکس/ویدیو) را ارسال کنید.\nبعد از اتمام دکمه '✅ اتمام گالری' را بزنید.",
                'reply_markup' => json_encode(['keyboard' => [[['text' => '✅ اتمام گالری']]], 'resize_keyboard' => true])]);
        } else {
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "لطفا یک عکس ارسال کنید."]);
        }
    }
    elseif ($step == 'add_prod_gallery') {
        $user = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
        $user->execute([$chat_id]);
        $temp = json_decode($user->fetchColumn(), true);
        if(!isset($temp['gallery'])) $temp['gallery'] = [];

        if ($text == '✅ اتمام گالری') {
             $stmt = $db->pdo->prepare("UPDATE users SET step = 'add_prod_price', temp_data = ? WHERE id = ?");
             $stmt->execute([json_encode($temp), $chat_id]);
             bot('sendMessage', ['chat_id' => $chat_id, 'text' => "5️⃣ قیمت اصلی محصول (به تومان) را وارد کنید (فقط عدد):", 'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 انصراف']]], 'resize_keyboard' => true])]);
        } else {
            $file_id = null;
            $type = 'unknown';
            if(isset($message->photo)) { $file_id = end($message->photo)->file_id; $type = 'image'; }
            elseif(isset($message->video)) { $file_id = $message->video->file_id; $type = 'video'; }

            if($file_id) {
                $path = saveFile($file_id, 'gallery');
                $temp['gallery'][] = ['path' => $path, 'type' => $type];
                $stmt = $db->pdo->prepare("UPDATE users SET temp_data = ? WHERE id = ?");
                $stmt->execute([json_encode($temp), $chat_id]);
                bot('sendMessage', ['chat_id' => $chat_id, 'text' => "فایل دریافت شد. بعدی یا اتمام."]);
            }
        }
    }
    elseif ($step == 'add_prod_price' && is_numeric($text)) {
        $user = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
        $user->execute([$chat_id]);
        $temp = json_decode($user->fetchColumn(), true);
        $temp['price'] = $text;

        $stmt = $db->pdo->prepare("UPDATE users SET step = 'add_prod_off_price', temp_data = ? WHERE id = ?");
        $stmt->execute([json_encode($temp), $chat_id]);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "6️⃣ قیمت با تخفیف را وارد کنید (اگر تخفیف ندارد 0 بفرستید):"]);
    }
   
       elseif ($step == 'add_prod_off_price' && is_numeric($text)) {
        $user = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
        $user->execute([$chat_id]);
        $temp = json_decode($user->fetchColumn(), true);
        
        // بررسی اعتبار قیمت تخفیف
        if ($text > 0 && $text >= $temp['price']) {
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "⛔️ خطا: قیمت تخفیف خورده نمی‌تواند بیشتر یا مساوی قیمت اصلی (" . number_format($temp['price']) . " تومان) باشد.\nلطفاً یک مبلغ کمتر وارد کنید (یا 0 برای حذف تخفیف):"
            ]);
            return; // توقف عملیات
        }
        
        $temp['off_price'] = $text;

        if ($text > 0) {
            // اگر تخفیف داشت، تاریخ انقضا بپرس
            $stmt = $db->pdo->prepare("UPDATE users SET step = 'add_prod_off_date', temp_data = ? WHERE id = ?");
            $stmt->execute([json_encode($temp), $chat_id]);
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "تاریخ انقضای تخفیف را وارد کنید (مثال: 1403/12/29):"]);
        } else {
             // اگر تخفیف 0 بود (تخفیف ندارد)، تاریخ نال شود و برو سراغ قیمت استارز
             $temp['off_date'] = null;
             
             // تغییر مسیر به step دریافت قیمت استارز (اینجا قبلاً اشتباه بود)
             $stmt = $db->pdo->prepare("UPDATE users SET step = 'add_prod_stars_price', temp_data = ? WHERE id = ?");
             $stmt->execute([json_encode($temp), $chat_id]);
             
             bot('sendMessage', ['chat_id' => $chat_id, 'text' => "⭐️ قیمت محصول به **استارز** را وارد کنید (عدد صحیح وارد کنید):\n\n❌ برای غیرفعال سازی قابلیت خرید با استارز برای این محصول عدد 0 را بفرستید."]);
        }
    }

      elseif ($step == 'add_prod_off_date') {
        $user = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
        $user->execute([$chat_id]);
        $temp = json_decode($user->fetchColumn(), true);
        
        $parts = explode('/', $text);
        if(count($parts) == 3) {
             // تبدیل شمسی به میلادی
             // فرض بر این است که تابع shamsi_to_miladi که در بالا دادم در functions.php موجود است
             list($gy, $gm, $gd) = shamsi_to_miladi($parts[0], $parts[1], $parts[2]);
             
             // ساخت تاریخ میلادی استاندارد برای دیتابیس (Y-m-d)
             $gregorian_date = sprintf("%04d-%02d-%02d", $gy, $gm, $gd);
             
                        $temp['off_date'] = $gregorian_date; 
             
             // تغییر مسیر به دریافت قیمت استارز
             $stmt = $db->pdo->prepare("UPDATE users SET step = 'add_prod_stars_price', temp_data = ? WHERE id = ?");
             $stmt->execute([json_encode($temp), $chat_id]);
             bot('sendMessage', ['chat_id' => $chat_id, 'text' => "⭐️ قیمت محصول به **استارز** را وارد کنید (عدد صحیح وارد کنید):\n\n❌ برای غیرفعال سازی قابلیت خرید با استارز برای این محصول عدد 0 را بفرستید."]);

        } else {
             bot('sendMessage', ['chat_id' => $chat_id, 'text' => "فرمت تاریخ اشتباه است. مجدد ارسال کنید (مثال: 1403/12/29):"]);
        }
    }
    
        // --- دریافت قیمت استارز ---
    elseif ($step == 'add_prod_stars_price' && is_numeric($text)) {
        $user = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
        $user->execute([$chat_id]);
        $temp = json_decode($user->fetchColumn(), true);
        
        $temp['price_stars'] = $text;

        $stmt = $db->pdo->prepare("UPDATE users SET step = 'add_prod_stars_off_price', temp_data = ? WHERE id = ?");
        $stmt->execute([json_encode($temp), $chat_id]);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "🎁 قیمت **تخفیف خورده** استارز را وارد کنید:\n(اگر تخفیف ندارد 0 بفرستید)"]);
    }

    // --- دریافت قیمت تخفیف استارز ---
    elseif ($step == 'add_prod_stars_off_price' && is_numeric($text)) {
        $user = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
        $user->execute([$chat_id]);
        $temp = json_decode($user->fetchColumn(), true);

        if ($text > 0 && $text >= $temp['price_stars']) {
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "⛔️ قیمت تخفیف نمی‌تواند از قیمت اصلی بیشتر باشد."]);
            return;
        }

        $temp['off_price_stars'] = $text;

        if ($text > 0) {
            $stmt = $db->pdo->prepare("UPDATE users SET step = 'add_prod_stars_off_date', temp_data = ? WHERE id = ?");
            $stmt->execute([json_encode($temp), $chat_id]);
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "📅 تاریخ انقضای تخفیف استارز را وارد کنید (مثال: 1403/12/29):"]);
        } else {
            $temp['off_date_stars'] = null;
            $stmt = $db->pdo->prepare("UPDATE users SET step = 'add_prod_link', temp_data = ? WHERE id = ?");
            $stmt->execute([json_encode($temp), $chat_id]);
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "🔗 لینک پیش‌نمایش محصول را همراه با (https) وارد کنید:"]);
        }
    }

    // --- دریافت تاریخ انقضای تخفیف استارز ---
    elseif ($step == 'add_prod_stars_off_date') {
        $user = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
        $user->execute([$chat_id]);
        $temp = json_decode($user->fetchColumn(), true);

        $parts = explode('/', $text);
        if(count($parts) == 3) {
             // تبدیل تاریخ (فرض بر وجود تابع shamsi_to_miladi در functions.php)
                        // تبدیل تاریخ با استفاده از تابع دقیق
             list($gy, $gm, $gd) = shamsi_to_miladi($parts[0], $parts[1], $parts[2]);
             $gregorian_date = sprintf("%04d-%02d-%02d", $gy, $gm, $gd);

             
             $temp['off_date_stars'] = $gregorian_date;

             $stmt = $db->pdo->prepare("UPDATE users SET step = 'add_prod_link', temp_data = ? WHERE id = ?");
             $stmt->execute([json_encode($temp), $chat_id]);
             bot('sendMessage', ['chat_id' => $chat_id, 'text' => "🔗 لینک پیش‌نمایش محصول را همراه با (https) وارد کنید:"]);
        } else {
             bot('sendMessage', ['chat_id' => $chat_id, 'text' => "⛔️ فرمت تاریخ اشتباه است. دوباره تلاش کنید (مثال: 1403/01/01)"]);
        }
    }


      elseif ($step == 'add_prod_link') {
        // ذخیره لینک محصول
        $user = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
        $user->execute([$chat_id]);
        $temp = json_decode($user->fetchColumn(), true);
        $temp['link'] = $text;
        
        // آماده‌سازی آرایه برای ذخیره دسته‌های انتخاب شده (خالی در ابتدا)
        $temp['selected_cats'] = [];

        // تغییر وضعیت به مرحله جدید (انتخاب چندگانه)
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'add_prod_multicat', temp_data = ? WHERE id = ?");
        $stmt->execute([json_encode($temp), $chat_id]);

        // دریافت لیست دسته‌ها
        $cats = $db->pdo->query("SELECT * FROM categories")->fetchAll();
        
        $keyboard = [];
        // ایجاد دکمه برای هر دسته (بدون تیک در ابتدا)
        foreach($cats as $c) {
            // فرمت دیتا: toggle_cat_add_ID
            $keyboard[] = [['text' => $c['name'], 'callback_data' => "toggle_cat_add_" . $c['id']]];
        }
        // دکمه تایید نهایی
        $keyboard[] = [['text' => '✅ ثبت و ادامه', 'callback_data' => "submit_cat_add"]];

        bot('sendMessage', [
            'chat_id' => $chat_id, 
            'text' => "8️⃣ دسته‌بندی‌های محصول را انتخاب کنید:\n(روی نام دسته‌ها بزنید تا تیک ✅ بخورد، سپس دکمه ثبت را بزنید)", 
            'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
        ]);
    }

       // --- دریافت توضیحات بیشتر (Step جدید - اصلاح شده برای دریافت چند پیام) ---
    elseif ($step == 'add_prod_more_desc') {
        // دریافت اطلاعات موقت فعلی (temp_data)
        $user_stmt = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
        $user_stmt->execute([$chat_id]);
        $temp = json_decode($user_stmt->fetchColumn(), true);
        
        // ۱. اگر کاربر دکمه پایان را زد یا گفت ندارم (خروج از مرحله)
        if ($text == '✅ پایان و ثبت توضیحات' || $text == 'ندارم (none)' || $text == 'none') {
            
            // اگر گفت "ندارم" و قبلاً هم متنی نفرستاده بود، مقدار را null کن
            if (($text == 'ندارم (none)' || $text == 'none') && empty($temp['more_desc'])) {
                $temp['more_desc'] = null;
            }
            // اگر دکمه "پایان" را زد، هر متنی که تا الان جمع شده در $temp['more_desc'] باقی می‌ماند

            // رفتن به مرحله بعدی (روزهای پشتیبانی)
            $stmt = $db->pdo->prepare("UPDATE users SET step = 'add_prod_support', temp_data = ? WHERE id = ?");
            $stmt->execute([json_encode($temp), $chat_id]);
            
            bot('sendMessage', [
                'chat_id' => $chat_id, 
                'text' => "✅ توضیحات بیشتر ثبت شد.\n\n9️⃣ مدت زمان پشتیبانی (روز) را وارد کنید:\n\n❌ در صورت عدم پشتیبانی از محصول عدد 0 را بفرستید", 
                'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 انصراف']]], 'resize_keyboard' => true])
            ]);
        } 
        // ۲. اگر متنی ارسال کرد (دریافت و چسباندن به متن قبلی)
        else {
            // بررسی کن قبلاً متنی داشته یا نه
            $current_text = isset($temp['more_desc']) ? $temp['more_desc'] : '';
            
            if (empty($current_text)) {
                $temp['more_desc'] = $text; // پیام اول
            } else {
                $temp['more_desc'] = $current_text . "\n\n" . $text; // چسباندن پیام جدید به قبلی
            }

            // ذخیره در temp_data (بدون تغییر step)
            $stmt = $db->pdo->prepare("UPDATE users SET temp_data = ? WHERE id = ?");
            $stmt->execute([json_encode($temp), $chat_id]);

            // پیام تایید و نمایش دکمه پایان
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "➕ متن اضافه شد.\n\nاگر توضیحات ادامه دارد، پیام بعدی را بفرستید.\n👇 اگر تمام شد، دکمه **«✅ پایان و ثبت توضیحات»** را بزنید.",
                'reply_markup' => json_encode([
                    'keyboard' => [
                        [['text' => '✅ پایان و ثبت توضیحات']]
                    ],
                    'resize_keyboard' => true
                ])
            ]);
        }
    }

    // --- دریافت توضیحات تکمیلی در حالت ویرایش (Multi-Step Edit) ---
    elseif ($step == 'admin_edit_more_desc_multi') {
        $stmt_u = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
        $stmt_u->execute([$chat_id]);
        $temp = json_decode($stmt_u->fetchColumn(), true);
        $pid = $temp['editing_pid']; // آیدی محصولی که داریم ویرایش می‌کنیم

        // 1. ذخیره نهایی
        if ($text == '✅ پایان و ثبت ویرایش') {
            $final_text = empty($temp['new_more_desc']) ? null : $temp['new_more_desc'];

            // آپدیت دیتابیس
            $stmt = $db->pdo->prepare("UPDATE products SET more_description = ? WHERE id = ?");
            $stmt->execute([$final_text, $pid]);

            // بازگشت به منوی ویرایش محصول
            $save_data = json_encode(['id' => $pid, 'field' => 'none']); // فیلد خاصی انتخاب نشده
            $db->pdo->prepare("UPDATE users SET step = 'admin_editing_product', temp_data = ? WHERE id = ?")->execute([$save_data, $chat_id]);

            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "✅ **توضیحات تکمیلی با موفقیت ویرایش و ذخیره شد.**\n\nبازگشت به منوی ویرایش:",
                'reply_markup' => adminMenu() // کیبورد اصلی ادمین برگردد
            ]);

            // نمایش مجدد پنل شیشه‌ای ویرایش
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "🛠 ادامه ویرایش محصول:",
                'reply_markup' => json_encode([
                    'inline_keyboard' => [
                        [['text' => '✏️ ویرایش مشخصات', 'callback_data' => "modify_select_" . $pid]],
                        [['text' => '🔙 بازگشت به لیست', 'callback_data' => "back_to_list"]]
                    ]
                ])
            ]);

        }
        // 2. انصراف
        elseif ($text == '🔙 انصراف') {
            // برگرداندن به حالت ویرایش معمولی
            $save_data = json_encode(['id' => $pid, 'field' => 'none']);
            $db->pdo->prepare("UPDATE users SET step = 'admin_editing_product', temp_data = ? WHERE id = ?")->execute([$save_data, $chat_id]);

            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "ویرایش توضیحات تکمیلی لغو شد.",
                'reply_markup' => adminMenu()
            ]);
             bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "🛠 ادامه ویرایش محصول:",
                'reply_markup' => json_encode([
                    'inline_keyboard' => [
                        [['text' => '✏️ ویرایش مشخصات', 'callback_data' => "modify_select_" . $pid]],
                        [['text' => '🔙 بازگشت به لیست', 'callback_data' => "back_to_list"]]
                    ]
                ])
            ]);
        }
        // 3. دریافت متن و تجمیع
        else {
            $current_text = isset($temp['new_more_desc']) ? $temp['new_more_desc'] : '';

            if (empty($current_text)) {
                $temp['new_more_desc'] = $text;
            } else {
                $temp['new_more_desc'] = $current_text . "\n\n" . $text;
            }

            // ذخیره در temp_data
            $db->pdo->prepare("UPDATE users SET temp_data = ? WHERE id = ?")->execute([json_encode($temp), $chat_id]);

            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "➕ متن دریافت شد.\n\n📝 **متن فعلی:**\n" . substr($temp['new_more_desc'], 0, 100) . "...\n\n👇 پیام بعدی را بفرستید یا اگر تمام شد دکمه **«✅ پایان و ثبت ویرایش»** را بزنید.",
                'reply_markup' => json_encode([
                    'keyboard' => [
                        [['text' => '✅ پایان و ثبت ویرایش']],
                        [['text' => '🔙 انصراف']]
                    ],
                    'resize_keyboard' => true
                ])
            ]);
        }
    }


    elseif ($step == 'add_prod_support' && is_numeric($text)) {
        $user = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
        $user->execute([$chat_id]);
        $temp = json_decode($user->fetchColumn(), true);
        $temp['support'] = $text;

        $stmt = $db->pdo->prepare("UPDATE users SET step = 'add_prod_files', temp_data = ? WHERE id = ?");
        $stmt->execute([json_encode($temp), $chat_id]);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "🔟 فایل‌های اصلی محصول (دانلودی) را ارسال کنید.\nپس از اتمام دکمه '✅ ثبت نهایی' را بزنید.", 'reply_markup' => json_encode(['keyboard' => [[['text' => '✅ ثبت نهایی']]], 'resize_keyboard' => true])]);
    }
    elseif ($step == 'add_prod_files') {
        $user = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
        $user->execute([$chat_id]);
        $temp = json_decode($user->fetchColumn(), true);
        if(!isset($temp['files'])) $temp['files'] = [];

                if ($text == '✅ ثبت نهایی') {
            
            // 1. درج محصول در جدول products (ستون category_id را نال میگذاریم یا 0)
            // نکته: در اینجا category_id را از کوئری حذف کردیم یا NULL می‌فرستیم
                     // کوئری اصلاح شده با more_description
            $sql = "INSERT INTO products (category_id, title, description, more_description, thumbnail, price, discount_price, discount_expiry, price_stars, discount_price_stars, discount_expiry_stars, preview_link, support_days) VALUES (NULL, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = $db->pdo->prepare($sql);

            $off_date = isset($temp['off_date']) ? $temp['off_date'] : null;
            $off_date_stars = isset($temp['off_date_stars']) ? $temp['off_date_stars'] : null;
            // دریافت توضیحات بیشتر از تمپ
            $more_desc_val = isset($temp['more_desc']) ? $temp['more_desc'] : null;

            $stmt->execute([
                $temp['title'],
                $temp['desc'],
                $more_desc_val, // <--- مقدار جدید اینجا پاس داده شد
                $temp['thumb'],
                $temp['price'],
                $temp['off_price'],
                $off_date,
                $temp['price_stars'] ?? 0,
                $temp['off_price_stars'] ?? 0,
                $off_date_stars,
                $temp['link'],
                $temp['support']
            ]);


            $prod_id = $db->pdo->lastInsertId();

            // 2. ثبت دسته‌بندی‌های چندگانه در جدول واسط
            // selected_cats شامل آیدی دسته‌های انتخاب شده است
            if (!empty($temp['selected_cats']) && is_array($temp['selected_cats'])) {
                // استفاده از تابعی که در functions.php ساختید
                updateProductCategories($prod_id, $temp['selected_cats']);
            }

            // 3. ادامه روال عادی (ثبت گالری و فایل‌ها)
            if (!empty($temp['gallery'])) {
                foreach($temp['gallery'] as $g) {
                    $db->pdo->prepare("INSERT INTO product_gallery (product_id, file_path, file_type) VALUES (?, ?, ?)")->execute([$prod_id, $g['path'], $g['type']]);
                }
            }

            // 4. ثبت فایل‌ها (همراه با کپشن) - اصلاح شده
            if (!empty($temp['files'])) {
                foreach($temp['files'] as $f) {
                    // بررسی وجود کپشن
                    $cap = isset($f['caption']) ? $f['caption'] : null;
                    
                    $db->pdo->prepare("INSERT INTO product_files (product_id, file_path, file_name, caption) VALUES (?, ?, ?, ?)")
                           ->execute([$prod_id, $f['path'], $f['name'], $cap]);
                }
            }

            $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_home', temp_data = '{}' WHERE id = ?");
            $stmt->execute([$chat_id]);
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "✅ محصول با موفقیت ایجاد شد.", 'reply_markup' => adminMenu()]);

        }

        elseif(isset($message->document)) {
            $path = saveFile($message->document->file_id, 'product_files');
            // دریافت کپشن فایل ارسالی - اصلاح شده
            $caption = isset($message->caption) ? $message->caption : null;

            $temp['files'][] = [
                'path' => $path, 
                'name' => $message->document->file_name,
                'caption' => $caption // ذخیره کپشن در تمپ
            ];


            $stmt = $db->pdo->prepare("UPDATE users SET temp_data = ? WHERE id = ?");
            $stmt->execute([json_encode($temp), $chat_id]);
            $msg_text = "فایل دریافت شد: " . $message->document->file_name;
            if($caption) $msg_text .= "\n📝 کپشن نیز دریافت شد.";
            
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => $msg_text]);
        }
    }
    
        // --- دریافت تاریخ انقضای تخفیف در ویرایش ---
    elseif ($step == 'admin_edit_off_date') {
        if ($text == '🔙 انصراف') {
            $db->pdo->prepare("UPDATE users SET step = 'admin_home', temp_data = '{}' WHERE id = ?")->execute([$chat_id]);
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "عملیات لغو شد.", 'reply_markup' => adminMenu()]);
        } else {
            $user = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
            $user->execute([$chat_id]);
            $temp = json_decode($user->fetchColumn(), true);
            
            $pid = $temp['id']; // شناسه محصول
            $new_off_price = $temp['new_off_price']; // قیمت تخفیفی که مرحله قبل وارد شده

            $parts = explode('/', $text);
            if(count($parts) == 3) {
                 // تبدیل شمسی به میلادی با استفاده از تابعی که در functions.php دارید
                 list($gy, $gm, $gd) = shamsi_to_miladi($parts[0], $parts[1], $parts[2]);
                 $gregorian_date = sprintf("%04d-%02d-%02d", $gy, $gm, $gd);

                 // بروزرسانی قیمت تخفیف و تاریخ انقضا همزمان
                 $stmt = $db->pdo->prepare("UPDATE products SET discount_price = ?, discount_expiry = ? WHERE id = ?");
                 $stmt->execute([$new_off_price, $gregorian_date, $pid]);

                 $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_home', temp_data = '{}' WHERE id = ?");
                 $stmt->execute([$chat_id]);

                 bot('sendMessage', [
                    'chat_id' => $chat_id,
                    'text' => "✅ قیمت تخفیف و تاریخ انقضای آن با موفقیت ذخیره شد.",
                    'parse_mode' => 'Markdown',
                    'reply_markup' => adminMenu()
                ]);
            } else {
                 bot('sendMessage', ['chat_id' => $chat_id, 'text' => "⚠️ فرمت تاریخ اشتباه است. لطفاً مجدد ارسال کنید (مثال: 1403/12/29):"]);
            }
        }
    }

       // --- دریافت تاریخ انقضای تخفیف استارز (کد جدید) ---
    elseif ($step == 'admin_edit_off_date_stars') {
        if ($text == '🔙 انصراف') {
            $db->pdo->prepare("UPDATE users SET step = 'admin_home', temp_data = '{}' WHERE id = ?")->execute([$chat_id]);
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "عملیات لغو شد.", 'reply_markup' => adminMenu()]);
        } else {
            $user = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
            $user->execute([$chat_id]);
            $temp = json_decode($user->fetchColumn(), true);

            $pid = $temp['id']; 
            $new_off_stars = $temp['new_off_price_stars']; 

            $parts = explode('/', $text);
            if(count($parts) == 3) {
                 // تبدیل شمسی به میلادی
                 list($gy, $gm, $gd) = shamsi_to_miladi($parts[0], $parts[1], $parts[2]);
                 $gregorian_date = sprintf("%04d-%02d-%02d", $gy, $gm, $gd);

                 // ذخیره در دیتابیس
                 $stmt = $db->pdo->prepare("UPDATE products SET discount_price_stars = ?, discount_expiry_stars = ? WHERE id = ?");
                 $stmt->execute([$new_off_stars, $gregorian_date, $pid]);

                 $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_home', temp_data = '{}' WHERE id = ?");
                 $stmt->execute([$chat_id]);

                 bot('sendMessage', [
                    'chat_id' => $chat_id,
                    'text' => "✅ قیمت تخفیف استارز و تاریخ انقضای آن با موفقیت ثبت شد.",
                    'parse_mode' => 'Markdown',
                    'reply_markup' => adminMenu()
                ]);
            } else {
                 bot('sendMessage', ['chat_id' => $chat_id, 'text' => "⚠️ فرمت تاریخ اشتباه است. لطفاً به صورت شمسی ارسال کنید (مثال: 1404/10/05):"]);
            }
        }
    }


    // --- دریافت مقدار ویرایش شده (نسخه کامل و اصلاح شده) ---
    elseif ($step == 'admin_editing_product') {
        
        if ($text == '🔙 انصراف') {
            $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_home', temp_data = '{}' WHERE id = ?");
            $stmt->execute([$chat_id]);
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "عملیات لغو شد.", 'reply_markup' => adminMenu()]);
            return;
        }

        $user = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
        $user->execute([$chat_id]);
        $temp = json_decode($user->fetchColumn(), true);
        $pid = $temp['id'];
        $field = $temp['field'];

        // 1. ویرایش تصویر شاخص
        if ($field == 'thumb') {
            if (isset($message->photo)) {
                $stmt = $db->pdo->prepare("SELECT thumbnail FROM products WHERE id = ?");
                $stmt->execute([$pid]);
                $old_thumb = $stmt->fetchColumn();

                $photo = end($message->photo);
                $new_path = saveFile($photo->file_id, 'thumbnails');

                if ($new_path) {
                    if ($old_thumb && file_exists(UPLOAD_DIR . $old_thumb)) {
                        unlink(UPLOAD_DIR . $old_thumb);
                    }
                    $db->pdo->prepare("UPDATE products SET thumbnail = ? WHERE id = ?")->execute([$new_path, $pid]);
                    
                    $db->pdo->prepare("UPDATE users SET step = 'admin_home', temp_data = '{}' WHERE id = ?")->execute([$chat_id]);
                    bot('sendMessage', ['chat_id' => $chat_id, 'text' => "✅ تصویر شاخص با موفقیت بروزرسانی شد.", 'reply_markup' => adminMenu()]);
                }
            } else {
                bot('sendMessage', ['chat_id' => $chat_id, 'text' => "لطفاً فقط یک عکس ارسال کنید."]);
            }
        }
        // 2. ویرایش فایل محصول
        elseif ($field == 'file') {
            if (isset($message->document)) {
                $stmt = $db->pdo->prepare("SELECT file_path FROM product_files WHERE product_id = ?");
                $stmt->execute([$pid]);
                $old_files = $stmt->fetchAll();

                $new_path = saveFile($message->document->file_id, 'product_files');
                
                              if ($new_path) {
                    // دریافت اطلاعات موقت کاربر برای بررسی وضعیت پاکسازی
                    $stmt_t = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
                    $stmt_t->execute([$chat_id]);
                    $t_data = json_decode($stmt_t->fetchColumn(), true);

                    // --- منطق هوشمند حذف فایل‌های قدیمی ---
                    // اگر کلید 'files_cleared' وجود نداشت، یعنی این اولین فایل از سری جدید است
                    // پس فایل‌های قدیمی دیتابیس را پاک می‌کنیم
                    if (!isset($t_data['files_cleared'])) {
                        
                        // 1. حذف فیزیکی و دیتابیسی فایل‌های قدیمی (طبق خواسته شما)
                        foreach ($old_files as $f) {
                            if (file_exists(UPLOAD_DIR . $f['file_path'])) unlink(UPLOAD_DIR . $f['file_path']);
                        }
                        $db->pdo->prepare("DELETE FROM product_files WHERE product_id = ?")->execute([$pid]);

                        // 2. ثبت نشانه که "پاکسازی انجام شد" تا فایل‌های بعدی این سری پاک نشوند
                        $t_data['files_cleared'] = true;
                        $db->pdo->prepare("UPDATE users SET temp_data = ? WHERE id = ?")->execute([json_encode($t_data), $chat_id]);
                        
                        $status_msg = "🗑 فایل‌های قدیمی حذف شدند و سری جدید ایجاد شد.\n";
                    } else {
                        $status_msg = ""; // برای فایل‌های دوم به بعد پیامی برای حذف نداریم
                    }

                    // --- درج فایل جدید ---
                    // دریافت کپشن
                    $caption = isset($message->caption) ? $message->caption : null;
                    
                    // ذخیره در دیتابیس
                    $db->pdo->prepare("INSERT INTO product_files (product_id, file_path, file_name, caption) VALUES (?, ?, ?, ?)")
                           ->execute([$pid, $new_path, $message->document->file_name, $caption]);

                    // --- نکته مهم: اینجا استپ را تغییر نمی‌دهیم تا ربات منتظر فایل بعدی بماند ---
                    
                    $msg = $status_msg . "✅ فایل جدید با موفقیت اضافه شد.";
                    if($caption) $msg .= "\n📝 کپشن نیز ثبت شد.";
                    $msg .= "\n\n📂 **فایل بعدی را ارسال کنید...**\n(برای اتمام ، دکمه **«🔙 انصراف»** را بزنید).";
                    
                     bot('sendMessage', [
                        'chat_id' => $chat_id, 
                        'text' => $msg, 
                        'reply_to_message_id' => $message->message_id // اصلاح شد: استفاده از $message->message_id
                    ]);
                }

            } else {
                bot('sendMessage', ['chat_id' => $chat_id, 'text' => "❌ لطفاً محصولات را به صورت فایل ارسال کنید."]);
            }
        }
        // 3. ویرایش گالری
        elseif ($field == 'gallery') {
            if ($text == '✅ اتمام ویرایش گالری') {
                $db->pdo->prepare("UPDATE users SET step = 'admin_home', temp_data = '{}' WHERE id = ?")->execute([$chat_id]);
                bot('sendMessage', ['chat_id' => $chat_id, 'text' => "✅ گالری تصاویر بروزرسانی شد.", 'reply_markup' => adminMenu()]);
            } 
            elseif (isset($message->photo) || isset($message->video)) {
                if (!isset($temp['gallery_cleared'])) {
                    $stmt = $db->pdo->prepare("SELECT file_path FROM product_gallery WHERE product_id = ?");
                    $stmt->execute([$pid]);
                    $old_gallery = $stmt->fetchAll();

                    foreach ($old_gallery as $g) {
                        if (file_exists(UPLOAD_DIR . $g['file_path'])) unlink(UPLOAD_DIR . $g['file_path']);
                    }
                    $db->pdo->prepare("DELETE FROM product_gallery WHERE product_id = ?")->execute([$pid]);
                    
                    $temp['gallery_cleared'] = true;
                    $db->pdo->prepare("UPDATE users SET temp_data = ? WHERE id = ?")->execute([json_encode($temp), $chat_id]);
                }

                $file_id = null;
                $type = 'unknown';
                if(isset($message->photo)) { $file_id = end($message->photo)->file_id; $type = 'image'; }
                elseif(isset($message->video)) { $file_id = $message->video->file_id; $type = 'video'; }

                if ($file_id) {
                    $path = saveFile($file_id, 'gallery');
                    $db->pdo->prepare("INSERT INTO product_gallery (product_id, file_path, file_type) VALUES (?, ?, ?)")
                           ->execute([$pid, $path, $type]);
                    bot('sendMessage', ['chat_id' => $chat_id, 'text' => "📥 فایل دریافت شد. بعدی را بفرستید یا اتمام را بزنید."]);
                }
            }
        }
        
        // 4. ویرایش متنی
        else {
            $new_value = $text;
            $col_name = '';

            switch ($field) {
                                case 'more_desc': $col_name = 'more_description'; break;
                case 'title': $col_name = 'title'; break;
                case 'price':
                    if(!is_numeric($new_value)) { bot('sendMessage', ['chat_id'=>$chat_id, 'text'=>"قیمت باید عدد باشد."]); return; }
                    $col_name = 'price';
                    break;
                                case 'offprice':
                    if(!is_numeric($new_value)) { bot('sendMessage', ['chat_id'=>$chat_id, 'text'=>"قیمت باید عدد باشد."]); return; }
                    
                    if ($new_value > 0) {
                        // دریافت قیمت اصلی فعلی محصول از دیتابیس
                        $stmt_check = $db->pdo->prepare("SELECT price FROM products WHERE id = ?");
                        $stmt_check->execute([$pid]);
                        $current_main_price = $stmt_check->fetchColumn();

                        if ($new_value >= $current_main_price) {
                            bot('sendMessage', [
                                'chat_id' => $chat_id, 
                                'text' => "⛔️ خطا: قیمت تخفیف خورده باید کمتر از قیمت اصلی (" . number_format($current_main_price) . " تومان) باشد.\nلطفاً مجدداً مبلغ صحیح را وارد کنید:"
                            ]);
                            return; // توقف عملیات و عدم ذخیره
                        }
                    }
                    if ($new_value > 0) {
                        // اگر قیمت تخفیف بیشتر از 0 بود، تاریخ را بپرس
                        $temp['new_off_price'] = $new_value;
                        $db->pdo->prepare("UPDATE users SET step = 'admin_edit_off_date', temp_data = ? WHERE id = ?")->execute([json_encode($temp), $chat_id]);
                        
                        bot('sendMessage', [
                            'chat_id' => $chat_id,
                            'text' => "📅 لطفاً تاریخ انقضای تخفیف را وارد کنید (مثال: 1403/12/29):",
                            'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 انصراف']]], 'resize_keyboard' => true])
                        ]);
                        return; // متوقف کردن عملیات تا دریافت تاریخ
                    } else {
                        // اگر قیمت 0 وارد شد، یعنی تخفیف حذف شود (تاریخ هم نال شود)
                        $db->pdo->prepare("UPDATE products SET discount_price = 0, discount_expiry = NULL WHERE id = ?")->execute([$pid]);
                        
                        $db->pdo->prepare("UPDATE users SET step = 'admin_home', temp_data = '{}' WHERE id = ?")->execute([$chat_id]);
                        bot('sendMessage', [
                            'chat_id' => $chat_id,
                            'text' => "✅ تخفیف محصول حذف شد.",
                            'reply_markup' => adminMenu()
                        ]);
                        return;
                    }
                    break;
                    
                               // --- ویرایش قیمت استارز (بخش جدید) ---
                case 'price_stars':
                    if(!is_numeric($new_value)) { bot('sendMessage', ['chat_id'=>$chat_id, 'text'=>"قیمت باید عدد باشد."]); return; }
                    $col_name = 'price_stars';
                    break;

                              // --- ویرایش قیمت تخفیف استارز ---
                case 'offprice_stars':
                    // 1. بررسی عدد بودن
                    if(!is_numeric($new_value)) { 
                        bot('sendMessage', ['chat_id'=>$chat_id, 'text'=>"قیمت باید عدد باشد."]); 
                        return; 
                    }

                    if ($new_value > 0) {
                        // 2. دریافت قیمت اصلی استارز از دیتابیس برای مقایسه
                        $stmt_check = $db->pdo->prepare("SELECT price_stars FROM products WHERE id = ?");
                        $stmt_check->execute([$pid]);
                        $current_stars = $stmt_check->fetchColumn();

                        // اگر قیمت اصلی ثبت نشده باشد یا صفر باشد، فرض را بر 0 می‌گیریم
                        if (!$current_stars) $current_stars = 0;

                        // 3. شرط مهم: تخفیف نباید بیشتر یا مساوی قیمت اصلی باشد
                        if ($new_value >= $current_stars) {
                            bot('sendMessage', [
                                'chat_id' => $chat_id,
                                'text' => "⛔️ خطا: قیمت تخفیف ($new_value) نمی‌تواند بیشتر یا مساوی قیمت اصلی استارز ($current_stars) باشد.\n\nلطفاً مبلغ صحیح (کمتر از قیمت اصلی) را وارد کنید:"
                            ]);
                            return; // توقف عملیات تا مدیر عدد درست را بفرستد
                        }
                        
                        // 4. اگر شرط پاس شد، ذخیره موقت و درخواست تاریخ
                        $temp['new_off_price_stars'] = $new_value;
                        $db->pdo->prepare("UPDATE users SET step = 'admin_edit_off_date_stars', temp_data = ? WHERE id = ?")->execute([json_encode($temp), $chat_id]);

                        bot('sendMessage', [
                            'chat_id' => $chat_id,
                            'text' => "📅 لطفاً **تاریخ انقضای تخفیف استارز** را به شمسی وارد کنید (مثال: 1404/10/05):",
                            'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 انصراف']]], 'resize_keyboard' => true])
                        ]);
                        return; 
                    } else {
                        // حذف تخفیف استارز (اگر عدد 0 وارد شد)
                        $db->pdo->prepare("UPDATE products SET discount_price_stars = 0, discount_expiry_stars = NULL WHERE id = ?")->execute([$pid]);
                        $db->pdo->prepare("UPDATE users SET step = 'admin_home', temp_data = '{}' WHERE id = ?")->execute([$chat_id]);
                        
                        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "✅ تخفیف استارز حذف شد.", 'reply_markup' => adminMenu()]);
                        return;
                    }
                    break;

                


                case 'desc': $col_name = 'description'; break;
                case 'support': $col_name = 'support_days'; break;
                case 'link': $col_name = 'preview_link'; break;
            }

            if ($col_name) {
                $sql = "UPDATE products SET $col_name = ? WHERE id = ?";
                $db->pdo->prepare($sql)->execute([$new_value, $pid]);
                $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_home', temp_data = '{}' WHERE id = ?");
                $stmt->execute([$chat_id]);

                bot('sendMessage', [
                    'chat_id' => $chat_id,
                    'text' => "✅ مقدار جدید ذخیره شد.",
                    'parse_mode' => 'Markdown',
                    'reply_markup' => adminMenu()
                ]);
            }
        }
    }

    // ==========================================
    //           بخش مدیریت کاربران
    // ==========================================

    // --- دریافت آیدی برای افزودن ادمین ---
    elseif ($step == 'admin_add_new_admin_id') {
        if ($text == '🔙 بازگشت به مدیریت ادمین‌ها') {
             // هندل شده در بالا
        } elseif (is_numeric($text)) {
            if (isConfigAdmin($chat_id)) {
                // بررسی اینکه آیدی خود مدیر اصلی نباشد
                if (in_array($text, CONFIG_ADMINS)) {
                    bot('sendMessage', ['chat_id' => $chat_id, 'text' => "⚠️ این آیدی متعلق به مدیر اصلی است و نیازی به افزودن ندارد."]);
                } else {
                    // تلاش برای افزودن
                    $res = addAdminToDB($text, "Admin (" . date("Y-m-d") . ")");
                    if ($res) {
                         bot('sendMessage', [
                             'chat_id' => $chat_id, 
                             'text' => "✅ ادمین جدید با آیدی `$text` با موفقیت اضافه شد.\n\nاکنون این کاربر به پنل مدیریت دسترسی دارد.",
                             'parse_mode' => 'Markdown',
                             'reply_markup' => adminManagementMenu()
                         ]);
                         $db->pdo->prepare("UPDATE users SET step = 'admin_manage_admins' WHERE id = ?")->execute([$chat_id]);
                         
                         // اطلاع به ادمین جدید
                         bot('sendMessage', [
                             'chat_id' => $text,
                             'text' => "🎉 تبریک! شما توسط مدیر اصلی به عنوان **ادمین ربات** منصوب شدید.\nبرای ورود به پنل دستور /start را بزنید."
                         ]);
                    } else {
                         bot('sendMessage', ['chat_id' => $chat_id, 'text' => "❌ این کاربر قبلاً در لیست ادمین‌ها وجود دارد."]);
                    }
                }
            }
        } else {
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "🔢 لطفاً فقط آیدی عددی ارسال کنید."]);
        }
    }


    // --- 1. درخواست جستجوی کاربر ---
    elseif ($text == '🔎 جستجوی کاربر') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_search_user' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "🔎 **جستجوی کاربر**\n\nلطفاً یکی از موارد زیر را ارسال کنید:\n🔹 نام کاربری (با @ یا بدون @)\n🔹 آیدی عددی (User ID)\n🔹 شماره موبایل (مثال: 98912...)\n\n👇 ورودی خود را ارسال کنید:",
            'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 بازگشت به تنظیمات فروشگاه']]], 'resize_keyboard' => true])
        ]);
    }

    // --- 2. پردازش جستجو و نمایش نتیجه ---
      elseif ($step == 'admin_search_user' && $text != '🔙 بازگشت به تنظیمات فروشگاه') {
        // تابع searchUser باید در functions.php وجود داشته باشد
        $user_info = searchUser($text); 

        if ($user_info) {
            $uid = $user_info['id'];
            
            // --- اصلاح باگ: استفاده از تابع escapeMarkdown برای جلوگیری از خطا ---
            $raw_username = $user_info['username'] ?? '';
            $uname = $raw_username ? "@" . escapeMarkdown($raw_username) : "ندارد";
            $uphone = escapeMarkdown($user_info['phone'] ?? "ثبت نشده");
            $joined = escapeMarkdown($user_info['joined_at'] ?? "نامشخص");
            // -------------------------------------------------------------------

            $msg = "👤 **اطلاعات کاربر یافت شد:**\n\n";
            $msg .= "🆔 آیدی عددی: `$uid`\n";
            $msg .= "👤 یوزرنیم: $uname\n";
            $msg .= "📱 شماره تماس: $uphone\n";
            $msg .= "📅 تاریخ عضویت: $joined\n";
            
            // دکمه‌های عملیاتی برای کاربر (بدون تغییر، دقیقاً طبق کد شما)
            $buttons = [
                [
                    ['text' => '✉️ ارسال پیام به کاربر', 'callback_data' => "admin_msg_user_$uid"],
                    ['text' => '🛍 لیست خریدها', 'callback_data' => "admin_user_orders_$uid"]
                ],
                [
                    ['text' => '➕ افزودن دستی محصول', 'callback_data' => "admin_add_prod_user_$uid"],
                    ['text' => '🧾 تراکنش‌های کاربر', 'callback_data' => "admin_user_trans_$uid"]
                ]
            ];

            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => $msg,
                'parse_mode' => 'Markdown',
                'reply_markup' => json_encode(['inline_keyboard' => $buttons])
            ]);
            
            // ریست کردن استپ
            $db->pdo->prepare("UPDATE users SET step = 'none' WHERE id = ?")->execute([$chat_id]);

        } else {
            bot('sendMessage', [
                'chat_id' => $chat_id, 
                'text' => "❌ کاربری با این مشخصات یافت نشد.\nمجدد تلاش کنید ی دهید."
            ]);
        }
    }

    // --- 3. دریافت پیام برای ارسال به کاربر ---
    elseif ($step == 'admin_sending_msg_to_user') {
        if ($text == '🔙 انصراف') {
            $db->pdo->prepare("UPDATE users SET step = 'none', temp_data = '{}' WHERE id = ?")->execute([$chat_id]);
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "ارسال پیام لغو شد.", 'reply_markup' => adminMenu()]);
        } else {
            // دریافت آیدی کاربر هدف از temp_data
            $stmt = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
            $stmt->execute([$chat_id]);
            $temp = json_decode($stmt->fetchColumn(), true);
            $target_uid = $temp['target_user_id'];

            // تشخیص نوع پیام (متن، عکس، ویدیو و...)
            $send_data = ['chat_id' => $target_uid];
            $method = 'sendMessage';

            if (isset($message->text)) {
                $send_data['text'] = "📬 **پیام از طرف مدیریت فروشگاه:**\n\n" . $message->text;
                $send_data['parse_mode'] = 'Markdown';
            } elseif (isset($message->photo)) {
                $method = 'sendPhoto';
                $send_data['photo'] = end($message->photo)->file_id;
                $send_data['caption'] = "📬 **پیام مدیریت:**\n" . ($message->caption ?? '');
            } elseif (isset($message->video)) {
                $method = 'sendVideo';
                $send_data['video'] = $message->video->file_id;
                $send_data['caption'] = "📬 **پیام مدیریت:**\n" . ($message->caption ?? '');
            } elseif (isset($message->voice)) {
                $method = 'sendVoice';
                $send_data['voice'] = $message->voice->file_id;
                $send_data['caption'] = "📬 **پیام مدیریت:**\n" . ($message->caption ?? '');
            } elseif (isset($message->document)) {
                $method = 'sendDocument';
                $send_data['document'] = $message->document->file_id;
                $send_data['caption'] = "📬 **پیام مدیریت:**\n" . ($message->caption ?? '');
            }

            $res = bot($method, $send_data);

            if ($res->ok) {
                bot('sendMessage', ['chat_id' => $chat_id, 'text' => "✅ پیام با موفقیت برای کاربر ارسال شد.", 'reply_markup' => adminMenu()]);
            } else {
                bot('sendMessage', ['chat_id' => $chat_id, 'text' => "❌ ارسال ناموفق. (شاید کاربر ربات را بلاک کرده است)", 'reply_markup' => adminMenu()]);
            }

            // خروج از حالت ارسال
            $db->pdo->prepare("UPDATE users SET step = 'none', temp_data = '{}' WHERE id = ?")->execute([$chat_id]);
        }
    }

    // --- 4. جستجوی محصول برای افزودن به کاربر ---
    elseif ($step == 'admin_find_prod_for_user') {
        if ($text == '🔙 انصراف') {
            $db->pdo->prepare("UPDATE users SET step = 'none', temp_data = '{}' WHERE id = ?")->execute([$chat_id]);
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "عملیات لغو شد.", 'reply_markup' => adminMenu()]);
        } else {
            // جستجوی محصول با بخشی از نام
            $products = findProductsForAdmin($text); // تابع در functions.php

            if ($products) {
                $stmt = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
                $stmt->execute([$chat_id]);
                $temp = json_decode($stmt->fetchColumn(), true);
                $target_uid = $temp['target_user_id'];

                $keys = [];
                foreach ($products as $p) {
                    // دکمه انتخاب محصول: admin_give_prod_USERID_PRODUCTID
                    $keys[] = [['text' => "🎁 " . $p['title'], 'callback_data' => "admin_give_prod_{$target_uid}_{$p['id']}"]];
                }
                $keys[] = [['text' => '🔙 انصراف', 'callback_data' => 'admin_cancel_gift']];

                bot('sendMessage', [
                    'chat_id' => $chat_id,
                    'text' => "🔍 محصولات یافت شده برای \"$text\":\n\nبرای اهدای محصول به کاربر، روی نام آن کلیک کنید:",
                    'reply_markup' => json_encode(['inline_keyboard' => $keys])
                ]);
                
                // استپ را تغییر نمیدهیم یا روی همین نگه میداریم
            } else {
                bot('sendMessage', ['chat_id' => $chat_id, 'text' => "❌ محصولی یافت نشد. نام دیگری وارد کنید:"]);
            }
        }
    }

       // --- 5. دریافت علت رد فیش (اصلاح شده: ثبت نام ادمین بررسی کننده) ---
    elseif ($step == 'admin_reject_reason') {
        if ($text == '🔙 انصراف') {
            $db->pdo->prepare("UPDATE users SET step = 'admin_home', temp_data = '{}' WHERE id = ?")->execute([$chat_id]);
            bot('sendMessage', ['chat_id' => $chat_id, 'text' => "عملیات رد فیش لغو شد.", 'reply_markup' => adminMenu()]);
        } else {
            // دریافت اطلاعات
            $stmt = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
            $stmt->execute([$chat_id]);
            $temp = json_decode($stmt->fetchColumn(), true);
            $order_id = $temp['reject_order_id'];
            $admin_msg_id = $temp['admin_msg_id'] ?? null;

            // --- بررسی مجدد جهت جلوگیری از تداخل ---
            $check = $db->pdo->prepare("SELECT processed_by FROM orders WHERE id = ?");
            $check->execute([$order_id]);
            $is_processed = $check->fetchColumn();

            if ($is_processed) {
                bot('sendMessage', ['chat_id' => $chat_id, 'text' => "⛔️ دیر رسیدی! این سفارش توسط ادمین دیگری بررسی شده است.", 'reply_markup' => adminMenu()]);
                // خروج از حالت
                $db->pdo->prepare("UPDATE users SET step = 'admin_home', temp_data = '{}' WHERE id = ?")->execute([$chat_id]);
                return;
            }
            // ---------------------------------------

            // 1. تغییر وضعیت سفارش به رد شده + ثبت آیدی ادمین (processed_by)
            $db->pdo->prepare("UPDATE orders SET status = 'rejected', processed_by = ? WHERE id = ?")->execute([$chat_id, $order_id]);
            
            // 2. پیدا کردن کاربر صاحب سفارش
            $ord = $db->pdo->prepare("SELECT user_id FROM orders WHERE id = ?");
            $ord->execute([$order_id]);
            $uid = $ord->fetchColumn();
            
            // 3. ارسال پیام رد شدن + علت به کاربر
            bot('sendMessage', [
                'chat_id' => $uid,
                'text' => "❌ **متأسفانه فیش واریزی شما رد شد.**\n\n📝 **علت:**\n$text\n\n📞 در صورت نیاز با پشتیبانی تماس بگیرید."
            ]);
            
            // 4. ویرایش پیام در کانال/پیوی ادمین
            if ($admin_msg_id) {
                // دریافت نام ادمین برای نمایش در کپشن
                $adm_name_q = $db->pdo->prepare("SELECT name FROM admins WHERE user_id = ?");
                $adm_name_q->execute([$chat_id]);
                $adm_name = $adm_name_q->fetchColumn() ?: "ادمین $chat_id";

                bot('editMessageCaption', [
                    'chat_id' => $chat_id,
                    'message_id' => $admin_msg_id,
                    'caption' => "❌ این سفارش توسط ($adm_name) رد شد.\n📝 علت ثبت شده: $text",
                    'reply_markup' => null
                ]);
            }

            // 5. پیام پایان
            $db->pdo->prepare("UPDATE users SET step = 'admin_home', temp_data = '{}' WHERE id = ?")->execute([$chat_id]);
            bot('sendMessage', [
                'chat_id' => $chat_id, 
                'text' => "✅ فیش رد شد و علت برای کاربر ارسال گردید.", 
                'reply_markup' => adminMenu()
            ]);
        }
    }


    // --- دکمه انصراف کلی ---
    if ($text == '🔙 انصراف') {
        $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_home', temp_data = '{}' WHERE id = ?");
        $stmt->execute([$chat_id]);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "عملیات لغو شد.", 'reply_markup' => adminMenu()]);
    }
}

// --- هندل کردن دکمه‌های شیشه‌ای مدیریت ---
if (isset($update->callback_query)) {
    $data = $update->callback_query->data;
    $cq_id = $update->callback_query->id;
    $chat_id_cb = $update->callback_query->message->chat->id;

        if (isAdmin($chat_id_cb)) {

              // --- حذف ادمین (فقط مدیر اصلی) ---
        if (strpos($data, 'del_admin_') === 0) {
            if (isConfigAdmin($chat_id_cb)) {
                $target_id = str_replace('del_admin_', '', $data);
                
                // --- اصلاحیه: حذف مستقیم از دیتابیس برای اطمینان کامل ---
                $db->pdo->prepare("DELETE FROM admins WHERE user_id = ?")->execute([$target_id]);
                
                bot('answerCallbackQuery', [

                    'callback_query_id' => $cq_id,
                    'text' => "✅ دسترسی ادمین مورد نظر حذف شد.",
                    'show_alert' => true
                ]);
                
                // بروزرسانی لیست
                bot('deleteMessage', ['chat_id' => $chat_id_cb, 'message_id' => $update->callback_query->message->message_id]);
            } else {
                bot('answerCallbackQuery', ['callback_query_id' => $cq_id, 'text' => "⛔️ شما دسترسی حذف ادمین را ندارید.", 'show_alert' => true]);
            }
        }

        // --- تغییر تنظیمات اعلان (فقط مدیر اصلی) ---
        if (strpos($data, 'set_notif_mode_') === 0) {
            if (isConfigAdmin($chat_id_cb)) {
                $mode = str_replace('set_notif_mode_', '', $data); // 'all' or 'creator'
                setSetting('admin_notification_mode', $mode);
                
                $msg_text = ($mode == 'all') ? "✅ تنظیم شد: ارسال برای همه مدیران" : "✅ تنظیم شد: ارسال فقط برای مدیر اصلی";
                
                bot('answerCallbackQuery', [
                    'callback_query_id' => $cq_id,
                    'text' => $msg_text,
                    'show_alert' => true
                ]);
                
                // رفرش کردن دکمه‌ها
                $keys = [];
                $text_all = ($mode == 'all') ? "✅ ارسال برای همه" : "ارسال برای همه";
                $text_creator = ($mode == 'creator') ? "✅ فقط مدیر اصلی" : "فقط مدیر اصلی";
                $keys[] = [['text' => $text_all, 'callback_data' => "set_notif_mode_all"], ['text' => $text_creator, 'callback_data' => "set_notif_mode_creator"]];
                
                bot('editMessageText', [
                    'chat_id' => $chat_id_cb,
                    'message_id' => $update->callback_query->message->message_id,
                    'text' => "🔔 **تنظیمات دریافت اعلان‌ها**\n\nوضعیت جدید: " . ($mode == 'creator' ? 'فقط مدیر اصلی' : 'همه مدیران'),
                    'reply_markup' => json_encode(['inline_keyboard' => $keys])
                ]);
            }
        }

        
                // --- الف) شروع پروسه ارسال پیام به کاربر ---
        if (strpos($data, 'admin_msg_user_') === 0) {
            $target_uid = str_replace('admin_msg_user_', '', $data);
            
            // ذخیره آیدی کاربر هدف و تغییر استپ
            $temp = ['target_user_id' => $target_uid];
            $db->pdo->prepare("UPDATE users SET step = 'admin_sending_msg_to_user', temp_data = ? WHERE id = ?")->execute([json_encode($temp), $chat_id_cb]);
            
            bot('sendMessage', [
                'chat_id' => $chat_id_cb,
                'text' => "✉️ لطفاً پیام خود را (متن، عکس، ویس و...) ارسال کنید تا برای کاربر فرستاده شود:",
                'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 انصراف']]], 'resize_keyboard' => true])
            ]);
            bot('answerCallbackQuery', ['callback_query_id' => $cq_id]);
        }

    // --- ب) نمایش لیست خریدهای کاربر (اصلاح شده: تشخیص استارز و تومان) ---
    elseif (strpos($data, 'admin_user_orders_') === 0) {
        $target_uid = str_replace('admin_user_orders_', '', $data);
        
        // دریافت سفارش‌ها
        $orders = getUserOrders($target_uid); 
        
        if ($orders) {
            $msg = "🛍 **لیست محصولات خریداری شده کاربر ($target_uid):**\n\n";
            foreach ($orders as $o) {
                // 1. استفاده از تابع جدید برای تشخیص تومان یا استارز
                // اگر ستون payment_method خالی بود، پیش‌فرض را zarinpal می‌گیریم
                $pm = $o['payment_method'] ?? 'zarinpal';
                $price_show = formatPrice($o['amount'], $pm);

                // 2. تبدیل تاریخ میلادی دیتابیس به شمسی (برای نمایش زیبا مثل تصویر)
                $time_parts = explode(' ', $o['created_at']); // جدا کردن تاریخ و ساعت
                $d = explode('-', $time_parts[0]);
                if(count($d) == 3) {
                     $j_date = gregorian_to_jalali($d[0], $d[1], $d[2], '/');
                     $final_date = $j_date . " | " . ($time_parts[1] ?? '');
                } else {
                     $final_date = $o['created_at'];
                }

                // ساخت پیام نهایی
                $msg .= "📦 " . $o['title'] . "\n🔖 مبلغ: " . $price_show . "\n📅 تاریخ: " . $final_date . "\n➖➖➖➖➖\n";
            }
        } else {
            $msg = "❌ این کاربر تاکنون هیچ خرید موفقی نداشته است.";
        }
        
        bot('sendMessage', ['chat_id' => $chat_id_cb, 'text' => $msg]);
        bot('answerCallbackQuery', ['callback_query_id' => $cq_id]);
    }


        // --- و) مشاهده ریز تراکنش‌های کاربر (موفق، ناموفق، رد شده) ---
        elseif (strpos($data, 'admin_user_trans_') === 0) {
            $target_uid = str_replace('admin_user_trans_', '', $data);

            // فراخوانی تابع جدید که در functions.php اضافه کردید
            // این تابع تمام سفارشات (پرداخت شده، رد شده، معلق) را برمی‌گرداند
            $transactions = getUserAllTransactions($target_uid);

            if ($transactions) {
                $msg = "🧾 **ریز تراکنش‌های کاربر ($target_uid):**\n\n";
                foreach ($transactions as $t) {
                    // استفاده از توابع کمکی که در functions.php اضافه کردید
                    $status_text = getStatusText($t['status']); 
                    $method_text = getPaymentMethodText($t['payment_method'] ?? 'online'); // اگر ستون متد خالی بود پیش‌فرض آنلاین
                    
                    // تعیین نام محصول (اگر محصول حذف شده باشد، پیام مناسب می‌دهد)
                    $p_name = !empty($t['product_title']) ? $t['product_title'] : '❌ محصول حذف شده/نامشخص';

                    
                    $amt = number_format($t['amount']);
                    // اگر مبلغ استارز بود، واحد را بنویس
                    $currency = ($t['payment_method'] == 'stars') ? 'استارز' : 'تومان';
                    
                                      // تبدیل تاریخ میلادی به شمسی
                    $time_parts = explode(' ', $t['created_at']);
                    $d = explode('-', $time_parts[0]);
                    if(count($d) == 3) {
                         $j_date = gregorian_to_jalali($d[0], $d[1], $d[2], '/');
                         $date = $j_date . " | " . ($time_parts[1] ?? '');
                    } else {
                         $date = $t['created_at'];
                    }


                    $msg .= "🔢 **سفارش:** `{$t['id']}`\n";
                    $msg .= "📦 **محصول:** $p_name\n";
                    $msg .= "💰 **مبلغ:** $amt $currency\n";
                    $msg .= "💳 **روش:** $method_text\n";
                    $msg .= "📊 **وضعیت:** $status_text\n";
                    $msg .= "📅 **تاریخ:** $date\n";
                    
                    // اگر تصویر رسید دارد (برای کارت به کارت)
                    if (!empty($t['receipt_image'])) {
                        $msg .= "📸 رسید دارد\n";
                    }
                    
                    $msg .= "〰〰〰〰〰\n";
                }
            } else {
                $msg = "❌ هیچ تراکنشی (موفق یا ناموفق) برای این کاربر ثبت نشده است.";
            }

            bot('sendMessage', [
                'chat_id' => $chat_id_cb,
                'text' => $msg,
                'parse_mode' => 'Markdown'
            ]);
            bot('answerCallbackQuery', ['callback_query_id' => $cq_id]);
        }


        // --- ج) شروع پروسه افزودن محصول به کاربر ---
        elseif (strpos($data, 'admin_add_prod_user_') === 0) {
            $target_uid = str_replace('admin_add_prod_user_', '', $data);
            
            $temp = ['target_user_id' => $target_uid];
            $db->pdo->prepare("UPDATE users SET step = 'admin_find_prod_for_user', temp_data = ? WHERE id = ?")->execute([json_encode($temp), $chat_id_cb]);
            
            bot('sendMessage', [
                'chat_id' => $chat_id_cb,
                'text' => "🔍 لطفاً **نام (یا بخشی از نام) محصول** را برای جستجو وارد کنید:",
                'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 انصراف']]], 'resize_keyboard' => true])
            ]);
            bot('answerCallbackQuery', ['callback_query_id' => $cq_id]);
        }
       
               // --- د) ثبت نهایی محصول برای کاربر (نسخه اصلاح شده: حذف لیست و ارسال پیام جدید) ---
        elseif (strpos($data, 'admin_give_prod_') === 0) {
            // فرمت دیتا: admin_give_prod_USERID_PRODUCTID
            $temp_str = str_replace('admin_give_prod_', '', $data);
            $parts = explode('_', $temp_str);
            
            if (count($parts) == 2) {
                $target_uid = $parts[0];
                $prod_id = $parts[1];
                
                // 1. افزودن سفارش به دیتابیس
                $res = addManualOrder($target_uid, $prod_id); 
                
                // 2. دریافت نام محصول
                $p_name = getProductName($prod_id);
                
                if ($res) {
                    // 3. حذف کامل پیام لیست محصولات (تا دیگر نمایش داده نشود)
                    bot('deleteMessage', [
                        'chat_id' => $chat_id_cb,
                        'message_id' => $update->callback_query->message->message_id
                    ]);

// 4. ارسال پیام موفقیت جدید (با دکمه بازگشت به تنظیمات فروشگاه)
                    bot('sendMessage', [
                        'chat_id' => $chat_id_cb,
                        'text' => "✅ **عملیات موفق**\n\nمحصول **$p_name** با موفقیت به لیست خریدهای کاربر `$target_uid` اضافه شد.",
                        'parse_mode' => 'Markdown',
                        'reply_markup' => json_encode([
                            'inline_keyboard' => [
                                [['text' => '🔙 بازگشت به تنظیمات فروشگاه', 'callback_data' => "admin_goto_store_settings"]]
                            ]
                        ])
                    ]);
                    // 5. پیام اطلاع‌رسانی به کاربر
                    bot('sendMessage', [
                        'chat_id' => $target_uid,
                        'text' => "🎁 **تبریک!**\n\nمحصول **$p_name** توسط مدیریت فروشگاه به حساب کاربری شما اضافه شد.\n\n📥 هم‌اکنون می‌توانید با مراجعه به دکمه **«محصولات من»** در منوی اصلی، فایل‌های آن را دانلود کنید.",
                        'parse_mode' => 'Markdown'
                    ]);
                } else {
                    bot('answerCallbackQuery', [
                        'callback_query_id' => $cq_id,
                        'text' => "❌ خطا در انجام عملیات.",
                        'show_alert' => true
                    ]);
                }
                
                // خروج از حالت و پاکسازی
                $db->pdo->prepare("UPDATE users SET step = 'none', temp_data = '{}' WHERE id = ?")->execute([$chat_id_cb]);
            }
        }

               // --- ه) بازگشت به تنظیمات فروشگاه (دکمه شیشه‌ای) ---
        elseif ($data == 'admin_goto_store_settings') {
            // تغییر استپ ادمین
            $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_store_settings' WHERE id = ?");
            $stmt->execute([$chat_id_cb]);

            // حذف پیام موفقیت (پیام قبلی) برای تمیز شدن صفحه
            // اصلاح خطا: استفاده از آیدی پیام صحیح از آبجکت آپدیت
            bot('deleteMessage', [
                'chat_id' => $chat_id_cb,
                'message_id' => $update->callback_query->message->message_id
            ]);

            // نمایش منوی تنظیمات فروشگاه
            bot('sendMessage', [
                'chat_id' => $chat_id_cb,
                'text' => "⚙️ **تنظیمات فروشگاه**\n\nلطفاً یکی از بخش‌های زیر را انتخاب کنید:",
                'parse_mode' => 'Markdown',
                'reply_markup' => storeSettingsMenu()
            ]);
        }



        // --- ه) انصراف از لیست محصولات (هنگام افزودن دستی) ---
        elseif ($data == 'admin_cancel_gift') {
            bot('deleteMessage', ['chat_id' => $chat_id_cb, 'message_id' => $update->callback_query->message->message_id]);
            bot('sendMessage', ['chat_id' => $chat_id_cb, 'text' => "انتخاب محصول لغو شد.", 'reply_markup' => adminMenu()]);
            $db->pdo->prepare("UPDATE users SET step = 'none' WHERE id = ?")->execute([$chat_id_cb]);
        }

        
                // --- هندل کردن کلیک روی دکمه جستجو ---
        if ($data == 'admin_search_prod') {
            // تغییر وضعیت کاربر به حالت انتظار برای دریافت کلمه جستجو
            $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_search_prod_wait' WHERE id = ?");
            $stmt->execute([$chat_id_cb]);

            bot('sendMessage', [
                'chat_id' => $chat_id_cb,
                'text' => "🔍 لطفاً قسمتی از نام محصول مورد نظر را وارد کنید:",
                'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 انصراف']]], 'resize_keyboard' => true])
            ]);
            
            // پاسخ به کال‌بک برای حذف ساعت شنی
            bot('answerCallbackQuery', ['callback_query_id' => $cq_id]);
        }


        // --- انتخاب سفارش برای تمدید (کال‌بک) ---
        if (strpos($data, 'select_ord_') === 0) {
            $order_id = str_replace('select_ord_', '', $data);
            
            // ذخیره آیدی سفارش و تغییر استپ برای دریافت تعداد روز
            $temp = ['extend_order_id' => $order_id];
            $db->pdo->prepare("UPDATE users SET step = 'admin_extend_get_days', temp_data = ? WHERE id = ?")->execute([json_encode($temp), $chat_id_cb]);
            
            bot('sendMessage', [
                'chat_id' => $chat_id_cb,
                'text' => "📅 **مدت تمدید را وارد کنید:**\n\nلطفاً تعداد روزهایی که می‌خواهید به پشتیبانی این محصول اضافه شود را به عدد ارسال کنید (مثلاً: 30):",
                'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 بازگشت به تنظیمات فروشگاه']]], 'resize_keyboard' => true])
            ]);
            
            bot('answerCallbackQuery', ['callback_query_id' => $cq_id]);
            
            // حذف پیام شیشه‌ای لیست محصولات
            bot('deleteMessage', ['chat_id' => $chat_id_cb, 'message_id' => $update->callback_query->message->message_id]);
        }


        // --- مدیریت دسته‌بندی‌ها (ویرایش/حذف) ---
        
        // 1. نمایش منوی مدیریت یک دسته خاص
        if (strpos($data, 'manage_cat_') === 0) {
            $cat_id = str_replace('manage_cat_', '', $data);
            $stmt = $db->pdo->prepare("SELECT name FROM categories WHERE id = ?");
            $stmt->execute([$cat_id]);
            $cat_name = $stmt->fetchColumn();

            if ($cat_name) {
                bot('editMessageText', [
                    'chat_id' => $chat_id_cb,
                    'message_id' => $update->callback_query->message->message_id,
                    'text' => "مدیریت دسته‌بندی: **$cat_name**\n\nیک گزینه را انتخاب کنید:",
                    'parse_mode' => 'Markdown',
                    'reply_markup' => json_encode([
                        'inline_keyboard' => [
                            [['text' => '✏️ ویرایش نام', 'callback_data' => "edit_cat_select_" . $cat_id]],
                            [['text' => '🗑 حذف دسته', 'callback_data' => "del_cat_ask_" . $cat_id]],
                            [['text' => '🔙 بازگشت به لیست', 'callback_data' => "back_to_cats"]]
                        ]
                    ])
                ]);
            } else {
                bot('answerCallbackQuery', ['callback_query_id' => $cq_id, 'text' => 'این دسته یافت نشد (شاید قبلاً حذف شده).', 'show_alert' => true]);
            }
        }

        // 2. درخواست نام جدید برای ویرایش
        elseif (strpos($data, 'edit_cat_select_') === 0) {
            $cat_id = str_replace('edit_cat_select_', '', $data);
            
            // ذخیره آی‌دی دسته در temp_data و تغییر استپ
            $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_save_edit_cat', temp_data = ? WHERE id = ?");
            $stmt->execute([$cat_id, $chat_id_cb]);

            bot('sendMessage', [
                'chat_id' => $chat_id_cb,
                'text' => "✏️ لطفاً نام جدید را برای این دسته‌بندی ارسال کنید:",
                'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 بازگشت به پنل']]], 'resize_keyboard' => true])
            ]);
            
            bot('answerCallbackQuery', ['callback_query_id' => $cq_id, 'text' => 'حالت ویرایش فعال شد.']);
        }

        // 3. پرسش اطمینان برای حذف
        elseif (strpos($data, 'del_cat_ask_') === 0) {
            $cat_id = str_replace('del_cat_ask_', '', $data);
            
            bot('editMessageText', [
                'chat_id' => $chat_id_cb,
                'message_id' => $update->callback_query->message->message_id,
                'text' => "⚠️ آیا مطمئن هستید که می‌خواهید این دسته را حذف کنید؟\n\nنکته: محصولاتی که در این دسته هستند بدون دسته خواهند شد (یا باید دستی ویرایش شوند).",
                'reply_markup' => json_encode([
                    'inline_keyboard' => [
                        [['text' => '✅ بله، حذف شود', 'callback_data' => "del_cat_final_" . $cat_id]],
                        [['text' => '❌ خیر، بازگشت', 'callback_data' => "manage_cat_" . $cat_id]]
                    ]
                ])
            ]);
        }

        // 4. انجام عملیات حذف نهایی
        elseif (strpos($data, 'del_cat_final_') === 0) {
            $cat_id = str_replace('del_cat_final_', '', $data);
            
            // حذف از دیتابیس
            $stmt = $db->pdo->prepare("DELETE FROM categories WHERE id = ?");
            $stmt->execute([$cat_id]);

            // اختیاری: می‌توان محصولاتی که در این دسته بودند را به دسته پیش‌فرض یا NULL برد
            // فعلاً فقط دسته حذف می‌شود.

            bot('answerCallbackQuery', ['callback_query_id' => $cq_id, 'text' => 'دسته‌بندی با موفقیت حذف شد.']);
            
            // بازگشت به لیست دسته‌ها
            $cats = $db->pdo->query("SELECT * FROM categories")->fetchAll();
            $keys = [];
            foreach($cats as $c) {
                $keys[] = [['text' => "📂 " . $c['name'], 'callback_data' => "manage_cat_" . $c['id']]];
            }
            
            bot('editMessageText', [
                'chat_id' => $chat_id_cb,
                'message_id' => $update->callback_query->message->message_id,
                'text' => "✅ حذف انجام شد.\n\n📋 لیست دسته‌بندی‌ها:",
                'reply_markup' => json_encode(['inline_keyboard' => $keys])
            ]);
        }

        // 5. بازگشت به لیست کلی دسته‌ها
        elseif ($data == 'back_to_cats') {
             $cats = $db->pdo->query("SELECT * FROM categories")->fetchAll();
             $keys = [];
             foreach($cats as $c) {
                 $keys[] = [['text' => "📂 " . $c['name'], 'callback_data' => "manage_cat_" . $c['id']]];
             }
             bot('editMessageText', [
                 'chat_id' => $chat_id_cb,
                 'message_id' => $update->callback_query->message->message_id,
                 'text' => "📋 لیست دسته‌بندی‌ها:",
                 'reply_markup' => json_encode(['inline_keyboard' => $keys])
             ]);
        }
        
        
                // --- حذف کد تخفیف (بخش جدید) ---
        if (strpos($data, 'del_coupon_') === 0) {
            $cid = str_replace('del_coupon_', '', $data);
            
            // حذف از دیتابیس
            $db->pdo->prepare("DELETE FROM coupons WHERE id = ?")->execute([$cid]);
            
            // نمایش نوتیفیکیشن
            bot('answerCallbackQuery', [
                'callback_query_id' => $cq_id, 
                'text' => "✅ کد تخفیف با موفقیت حذف شد."
            ]);
            
            // حذف پیام دکمه شیشه‌ای (تا دیگر دیده نشود)
            bot('deleteMessage', [
                'chat_id' => $chat_id_cb, 
                'message_id' => $update->callback_query->message->message_id
            ]);
        }

               // --- تایید پرداخت کارت به کارت (اصلاح شده: با بررسی processed_by) ---
        if (strpos($data, 'verify_card_') === 0) {
            $order_id = str_replace('verify_card_', '', $data);

            // 1. بررسی اینکه آیا قبلاً توسط ادمین دیگری پردازش شده است؟
            $check = $db->pdo->prepare("SELECT status, processed_by FROM orders WHERE id = ?");
            $check->execute([$order_id]);
            $ord_curr = $check->fetch();

            if ($ord_curr['processed_by'] != null) {
                // یافتن نام ادمین پردازش کننده
                $adm_q = $db->pdo->prepare("SELECT name FROM admins WHERE user_id = ?");
                $adm_q->execute([$ord_curr['processed_by']]);
                $processor_name = $adm_q->fetchColumn() ?: "ادمین دیگر";

                bot('answerCallbackQuery', [
                    'callback_query_id' => $cq_id,
                    'text' => "⛔️ دیر رسیدی! این سفارش توسط ادمین دیگری بررسی شده است.",
                    'show_alert' => true
                ]);
                // حذف دکمه‌ها برای جلوگیری از کلیک مجدد
                bot('editMessageReplyMarkup', [
                    'chat_id' => $chat_id_cb,
                    'message_id' => $update->callback_query->message->message_id,
                    'reply_markup' => null
                ]);
                return; 
            }

            // 2. آپدیت سفارش به پرداخت شده + ثبت آیدی ادمین (processed_by)
            $db->pdo->prepare("UPDATE orders SET status = 'paid', processed_by = ? WHERE id = ?")->execute([$chat_id_cb, $order_id]);

            // 3. دریافت اطلاعات سفارش
            $ord = $db->pdo->prepare("SELECT * FROM orders WHERE id = ?");
            $ord->execute([$order_id]);
            $order_info = $ord->fetch();

                       // 4. افزایش شمارنده کوپن و ثبت سابقه کاربر (برای جلوگیری از استفاده مجدد)
            if (!empty($order_info['coupon_id'])) {
                // الف: افزایش تعداد کل استفاده
                $db->pdo->prepare("UPDATE coupons SET used_count = used_count + 1 WHERE id = ?")->execute([$order_info['coupon_id']]);
                
                // ب: ثبت اینکه این کاربر از کد استفاده کرده است
                $db->pdo->prepare("INSERT INTO coupon_usage (user_id, coupon_id) VALUES (?, ?)")->execute([$order_info['user_id'], $order_info['coupon_id']]);
            }

            // 5. اطلاع به کاربر
            bot('sendMessage', [
                'chat_id' => $order_info['user_id'],
                'text' => "✅ پرداخت کارت به کارت شما تایید شد.\n\nهم‌اکنون می‌توانید فایل محصول را از بخش «محصولات من» دریافت کنید."
            ]);

            // 6. دریافت نام خود ادمین جاری برای لاگ
            $my_name_q = $db->pdo->prepare("SELECT name FROM admins WHERE user_id = ?");
            $my_name_q->execute([$chat_id_cb]);
            $my_name = $my_name_q->fetchColumn() ?: "شما";

            // 7. ویرایش پیام ادمین
            bot('editMessageCaption', [
                'chat_id' => $chat_id_cb,
                'message_id' => $update->callback_query->message->message_id,
                'caption' => $update->callback_query->message->caption . "\n\n✅ تایید شد توسط: $my_name",
                'reply_markup' => null 
            ]);
            
            bot('answerCallbackQuery', ['callback_query_id' => $cq_id, 'text' => "✅ سفارش تایید شد."]);
        }

        
                      // --- شروع رد فیش (اصلاح شده: بررسی تداخل) ---
        elseif (strpos($data, 'reject_card_') === 0) {
            $order_id = str_replace('reject_card_', '', $data);
            
            // 1. بررسی اینکه آیا قبلاً پردازش شده است؟
            $check = $db->pdo->prepare("SELECT processed_by FROM orders WHERE id = ?");
            $check->execute([$order_id]);
            $is_proc = $check->fetchColumn();

            if ($is_proc) {
                 bot('answerCallbackQuery', [
                    'callback_query_id' => $cq_id,
                    'text' => "⛔️ دیر رسیدی! این سفارش توسط ادمین دیگری بررسی شده است.",
                    'show_alert' => true
                ]);
                // حذف دکمه‌ها
                bot('editMessageReplyMarkup', [
                    'chat_id' => $chat_id_cb,
                    'message_id' => $update->callback_query->message->message_id,
                    'reply_markup' => null
                ]);
                return;
            }

            // 2. ادامه روال عادی (رفتن به مرحله دریافت دلیل)
            $temp = [
                'reject_order_id' => $order_id,
                'admin_msg_id' => $update->callback_query->message->message_id
            ];
            
            $db->pdo->prepare("UPDATE users SET step = 'admin_reject_reason', temp_data = ? WHERE id = ?")->execute([json_encode($temp), $chat_id_cb]);
            
            bot('sendMessage', [
                'chat_id' => $chat_id_cb,
                'text' => "❌ **لطفاً علت رد شدن این فیش را بنویسید:**\n\n(این متن مستقیماً برای کاربر ارسال خواهد شد)",
                'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 انصراف']]], 'resize_keyboard' => true])
            ]);
            
            bot('answerCallbackQuery', ['callback_query_id' => $cq_id]);
        }



        // 1. نمایش منوی مدیریت محصول
        if (strpos($data, 'edit_prod_') === 0) {
            $pid = str_replace('edit_prod_', '', $data);
            $stmt = $db->pdo->prepare("SELECT title FROM products WHERE id = ?");
            $stmt->execute([$pid]);
            $p_title = $stmt->fetchColumn();

            if ($p_title) {
                bot('editMessageText', [
                    'chat_id' => $chat_id_cb,
                    'message_id' => $update->callback_query->message->message_id,
                    'text' => "مدیریت محصول: **$p_title**\n\nچه کاری می‌خواهید انجام دهید؟",
                    'parse_mode' => 'Markdown',
                    'reply_markup' => json_encode([
                        'inline_keyboard' => [
                            [['text' => '✏️ ویرایش مشخصات', 'callback_data' => "modify_select_" . $pid]],
                            [['text' => '🗑 حذف محصول', 'callback_data' => "del_confirm_" . $pid]],
                            [['text' => '🔙 بازگشت به لیست', 'callback_data' => "back_to_list"]]
                        ]
                    ])
                ]);
            }
        }

        // 2. تایید حذف
        elseif (strpos($data, 'del_confirm_') === 0) {
            $pid = str_replace('del_confirm_', '', $data);
            bot('editMessageText', [
                'chat_id' => $chat_id_cb,
                'message_id' => $update->callback_query->message->message_id,
                'text' => "⚠️ آیا مطمئن هستید که می‌خواهید این محصول را حذف کنید؟\nاین عملیات غیرقابل بازگشت است.",
                'reply_markup' => json_encode([
                    'inline_keyboard' => [
                        [['text' => '✅ بله، حذف شود', 'callback_data' => "del_final_" . $pid]],
                        [['text' => '❌ خیر، انصراف', 'callback_data' => "edit_prod_" . $pid]]
                    ]
                ])
            ]);
        }

        // 3. انجام عملیات حذف (همراه با حذف فایل)
        elseif (strpos($data, 'del_final_') === 0) {
            $pid = str_replace('del_final_', '', $data);

            // حذف تصویر شاخص
            $stmt = $db->pdo->prepare("SELECT thumbnail FROM products WHERE id = ?");
            $stmt->execute([$pid]);
            $thumb = $stmt->fetchColumn();
            if ($thumb && file_exists(UPLOAD_DIR . $thumb)) unlink(UPLOAD_DIR . $thumb);

            // حذف گالری
            $stmt = $db->pdo->prepare("SELECT file_path FROM product_gallery WHERE product_id = ?");
            $stmt->execute([$pid]);
            $gallery_files = $stmt->fetchAll();
            foreach ($gallery_files as $gf) {
                if (file_exists(UPLOAD_DIR . $gf['file_path'])) unlink(UPLOAD_DIR . $gf['file_path']);
            }

            // حذف فایل محصول
            $stmt = $db->pdo->prepare("SELECT file_path FROM product_files WHERE product_id = ?");
            $stmt->execute([$pid]);
            $prod_files = $stmt->fetchAll();
            foreach ($prod_files as $pf) {
                if (file_exists(UPLOAD_DIR . $pf['file_path'])) unlink(UPLOAD_DIR . $pf['file_path']);
            }

            // پاک کردن از دیتابیس
            $db->pdo->prepare("DELETE FROM products WHERE id = ?")->execute([$pid]);
            $db->pdo->prepare("DELETE FROM product_gallery WHERE product_id = ?")->execute([$pid]);
            $db->pdo->prepare("DELETE FROM product_files WHERE product_id = ?")->execute([$pid]);
            $db->pdo->prepare("DELETE FROM orders WHERE product_id = ?")->execute([$pid]);

            bot('answerCallbackQuery', ['callback_query_id' => $cq_id, 'text' => 'محصول و تمامی فایل‌های آن حذف شدند.']);
            bot('editMessageText', [
                'chat_id' => $chat_id_cb,
                'message_id' => $update->callback_query->message->message_id,
                'text' => "✅ محصول و فایل‌های ضمیمه با موفقیت از هاست و دیتابیس حذف گردید."
            ]);
        }

        // 4. بازگشت به لیست محصولات
        elseif ($data == 'back_to_list') {
             $products = $db->pdo->query("SELECT id, title, price FROM products ORDER BY id DESC")->fetchAll();
             $keys = [];
             foreach ($products as $product) {
                 $keys[] = [['text' => "📦 " . $product['title'], 'callback_data' => "edit_prod_" . $product['id']]];
             }
             bot('editMessageText', [
                 'chat_id' => $chat_id_cb,
                 'message_id' => $update->callback_query->message->message_id,
                 'text' => "📑 **لیست محصولات فروشگاه:**",
                 'parse_mode' => 'Markdown',
                 'reply_markup' => json_encode(['inline_keyboard' => $keys])
             ]);
        }

        // 5. انتخاب فیلد برای ویرایش (با دکمه‌های جدید)
             // 5. انتخاب فیلد برای ویرایش (با دکمه‌های جدید)
        elseif (strpos($data, 'modify_select_') === 0) {
            $pid = str_replace('modify_select_', '', $data);
            bot('editMessageText', [
                'chat_id' => $chat_id_cb,
                'message_id' => $update->callback_query->message->message_id,
                'text' => "🛠 کدام بخش را می‌خواهید ویرایش کنید؟",
                'reply_markup' => json_encode([
                    'inline_keyboard' => [
                        [['text' => '🏷 عنوان', 'callback_data' => "do_edit_title_$pid"], ['text' => '📝 توضیحات', 'callback_data' => "do_edit_desc_$pid"]],
                        [['text' => '💰 قیمت اصلی', 'callback_data' => "do_edit_price_$pid"], ['text' => '🎉 قیمت با تخفیف', 'callback_data' => "do_edit_offprice_$pid"]],
                        
                        // --- این خط جدید برای استارز اضافه شد ---
                        [['text' => '⭐️ قیمت استارز', 'callback_data' => "do_edit_price_stars_$pid"], ['text' => '🏷 تخفیف استارز', 'callback_data' => "do_edit_offprice_stars_$pid"]],
                        // ---------------------------------------

                        [['text' => '📅 مدت پشتیبانی', 'callback_data' => "do_edit_support_$pid"], ['text' => '🔗 لینک پیش‌نمایش', 'callback_data' => "do_edit_link_$pid"]],
                        
                        [['text' => '🖼 تصویر شاخص', 'callback_data' => "do_edit_thumb_$pid"], ['text' => '📂 فایل محصول', 'callback_data' => "do_edit_file_$pid"]],
                        [['text' => '📸 گالری تصاویر', 'callback_data' => "do_edit_gallery_$pid"], ['text' => '📂 دسته‌بندی', 'callback_data' => "do_edit_cat_$pid"]],
                        
                         [['text' => '📄 توضیحات تکمیلی (More)', 'callback_data' => "do_edit_more_desc_$pid"]], // <--- این خط اضافه شود
                        
                        [['text' => '🔙 بازگشت', 'callback_data' => "edit_prod_$pid"]]
                    ]
                ])
            ]);
        }


        // --- کد جدید: ثبت نهایی تغییر دسته بندی ---
        elseif (strpos($data, 'set_new_cat_') === 0) {
            // فرمت دیتا: set_new_cat_PRODUCTID_CATID
            $temp = str_replace('set_new_cat_', '', $data);
            $parts = explode('_', $temp);
            
            if (count($parts) == 2) {
                $product_id = $parts[0];
                $cat_id = $parts[1];

                // آپدیت دیتابیس
                $stmt = $db->pdo->prepare("UPDATE products SET category_id = ? WHERE id = ?");
                $stmt->execute([$cat_id, $product_id]);

                // دریافت نام دسته برای نمایش در پیام موفقیت
                $stmt = $db->pdo->prepare("SELECT name FROM categories WHERE id = ?");
                $stmt->execute([$cat_id]);
                $cat_name = $stmt->fetchColumn();

                bot('answerCallbackQuery', [
                    'callback_query_id' => $cq_id,
                    'text' => "✅ دسته‌بندی محصول با موفقیت به '$cat_name' تغییر یافت.",
                    'show_alert' => true
                ]);

                // بازگشت به منوی ویرایش همان محصول
                bot('editMessageText', [
                    'chat_id' => $chat_id_cb,
                    'message_id' => $update->callback_query->message->message_id,
                    'text' => "✅ دسته‌بندی ویرایش شد.\n\nچه کاری می‌خواهید انجام دهید؟",
                    'reply_markup' => json_encode([
                        'inline_keyboard' => [
                            [['text' => '✏️ ویرایش مشخصات', 'callback_data' => "modify_select_" . $product_id]],
                            [['text' => '🔙 بازگشت به لیست', 'callback_data' => "back_to_list"]]
                        ]
                    ])
                ]);
            }
        }
        // --- پایان کد جدید ---

        // 6. آماده‌سازی برای دریافت مقدار جدید
        elseif (strpos($data, 'do_edit_') === 0) {
            $temp = str_replace('do_edit_', '', $data);
            $last_underscore = strrpos($temp, '_');
            $field = substr($temp, 0, $last_underscore);
            $pid = substr($temp, $last_underscore + 1);
            
                        // --- کدهای جدید: هندل کردن ویرایش توضیحات تکمیلی (چند مرحله‌ای) ---
            if ($field == 'more_desc') {
                // آماده‌سازی تمپ دیتا
                $temp_data = [
                    'editing_pid' => $pid,
                    'new_more_desc' => '' // شروع با متن خالی
                ];
                
                $db->pdo->prepare("UPDATE users SET step = 'admin_edit_more_desc_multi', temp_data = ? WHERE id = ?")
                        ->execute([json_encode($temp_data), $chat_id_cb]);

                bot('sendMessage', [
                    'chat_id' => $chat_id_cb,
                    'text' => "📄 **ویرایش توضیحات تکمیلی (More Description)**\n\n⚠️ توجه: متن‌های ارسالی شما **جایگزین** متن قبلی خواهند شد.\n\nشما می‌توانید توضیحات را در **چندین پیام** ارسال کنید. هر پیام به انتهای قبلی اضافه می‌شود.\n\n👇 اولین بخش متن را ارسال کنید:",
                    'parse_mode' => 'Markdown',
                    'reply_markup' => json_encode([
                        'keyboard' => [
                            [['text' => '✅ پایان و ثبت ویرایش']],
                            [['text' => '🔙 انصراف']]
                        ], 
                        'resize_keyboard' => true
                    ])
                ]);
                
                // توقف اجرای بقیه کد این بخش
                return;
            }
            // -----------------------------------------------------------------

                        // --- شروع کد جدید برای نمایش لیست دسته بندی ها ---
                        if ($field == 'cat') {
                               // دریافت دسته‌های فعلی محصول
                $current_cat_ids = getProductCategoryIds($pid); // تابع در functions.php
                
                // --- شروع اصلاحیه: خواندن صحیح temp_data از دیتابیس ---
                $stmt_u = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
                $stmt_u->execute([$chat_id_cb]);
                $temp_data_db = $stmt_u->fetchColumn();
                
                $temp_data_arr = json_decode($temp_data_db, true);
                // --- پایان اصلاحیه ---

                if(!$temp_data_arr) $temp_data_arr = [];
 
                $temp_data_arr['editing_pid'] = $pid;
                $temp_data_arr['selected_cats'] = $current_cat_ids;
                
                $db->pdo->prepare("UPDATE users SET temp_data = ? WHERE id = ?")->execute([json_encode($temp_data_arr), $chat_id_cb]);

                // ساخت کیبورد
                $cats = $db->pdo->query("SELECT * FROM categories")->fetchAll();
                $keys = [];
                foreach ($cats as $c) {
                    // بررسی تیک داشتن
                    $tick = in_array($c['id'], $current_cat_ids) ? "✅ " : "";
                    $keys[] = [['text' => $tick . $c['name'], 'callback_data' => "toggle_cat_edit_" . $c['id']]];
                }
                $keys[] = [['text' => '💾 ذخیره تغییرات', 'callback_data' => "submit_cat_edit"]];
                $keys[] = [['text' => '🔙 بازگشت', 'callback_data' => "modify_select_" . $pid]];

                bot('editMessageText', [
                    'chat_id' => $chat_id_cb,
                    'message_id' => $update->callback_query->message->message_id,
                    'text' => "📂 دسته‌بندی‌های محصول را ویرایش کنید:",
                    'reply_markup' => json_encode(['inline_keyboard' => $keys])
                ]);
                return; 
            }


            $field_names = [
                'title' => 'عنوان جدید',
                'price' => 'قیمت اصلی جدید (تومان)',
                'price_stars' => 'قیمت اصلی استارز (عدد)', // جدید
                'offprice' => 'قیمت با تخفیف جدید (0 برای حذف تخفیف)',
                'offprice_stars' => 'قیمت تخفیف استارز (0 برای حذف تخفیف)', // جدید
                'desc' => 'توضیحات جدید',
                'more_desc' => 'توضیحات بیشتر (متن طولانی/نامحدود)',
                'support' => 'تعداد روز پشتیبانی',
                'link' => 'لینک پیش‌نمایش جدید',
                'thumb' => 'تصویر شاخص جدید (یک عکس ارسال کنید)',
                'file' => 'فایل جدید محصول (فایل را آپلود کنید)',
                'gallery' => 'تصاویر جدید گالری (تصاویر را ارسال کنید و در پایان دکمه "✅ اتمام ویرایش گالری" را بزنید)'
            ];

            $save_data = json_encode(['id' => $pid, 'field' => $field]);
            $stmt = $db->pdo->prepare("UPDATE users SET step = 'admin_editing_product', temp_data = ? WHERE id = ?");
            $stmt->execute([$save_data, $chat_id_cb]);

            if ($field == 'gallery') {
                 bot('sendMessage', [
                    'chat_id' => $chat_id_cb,
                    'text' => "⚠️ توجه: با ارسال تصاویر جدید، **کل گالری قبلی حذف خواهد شد**.\n\n📸 لطفاً تصاویر جدید را یکی یکی ارسال کنید و در نهایت دکمه زیر را بزنید:",
                    'parse_mode' => 'Markdown',
                    'reply_markup' => json_encode(['keyboard' => [[['text' => '✅ اتمام ویرایش گالری']], [['text' => '🔙 انصراف']]], 'resize_keyboard' => true])
                ]);
            } else {
                bot('sendMessage', [
                    'chat_id' => $chat_id_cb,
                    'text' => "✏️ لطفاً **" . $field_names[$field] . "** را ارسال کنید:",
                    'parse_mode' => 'Markdown',
                    'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 انصراف']]], 'resize_keyboard' => true])
                ]);
            }
        }
      
    }
}

// ==================================================
//      مدیریت کامل دکمه‌های تایید شماره موبایل
//      (شامل: خاموش/روشن کردن اجبار + انتخاب کشور)
// ==================================================

// بررسی می‌کنیم اگر دکمه‌های مربوط به این بخش فشرده شده باشند
if ($data == 'toggle_phone_req' || $data == 'set_phone_mode_ir' || $data == 'set_phone_mode_all') {

    // 1. اگر دکمه تغییر وضعیت اجبار (روشن/خاموش) زده شد
    if ($data == 'toggle_phone_req') {
        $current = getSetting('force_phone_share');
        $new = ($current == 'on') ? 'off' : 'on'; // برعکس کردن وضعیت
        setSetting('force_phone_share', $new);
        
        $msg_text = ($new == 'on') ? "✅ دریافت شماره اجباری شد." : "❌ دریافت شماره اختیاری شد.";
        
        bot('answerCallbackQuery', [
            'callback_query_id' => $cq_id,
            'text' => $msg_text
        ]);
    }

    // 2. اگر دکمه‌های تغییر کشور (ایران/همه) زده شد
    elseif ($data == 'set_phone_mode_ir' || $data == 'set_phone_mode_all') {
        $mode = ($data == 'set_phone_mode_ir') ? 'ir' : 'all';
        setSetting('phone_restriction_mode', $mode);
        
        $mode_text = ($mode == 'ir') ? "🇮🇷 فقط ایران" : "🌍 همه کشورها";
        
        bot('answerCallbackQuery', [
            'callback_query_id' => $cq_id,
            'text' => "✅ تنظیم شد روی: $mode_text"
        ]);
    }

    // 3. نوسازی (رفرش) ظاهر منو تا تیک‌های سبز جابجا شوند
    bot('editMessageText', [
        'chat_id' => $chat_id_cb, // آیدی چت از کال‌بک
        'message_id' => $update->callback_query->message->message_id, // آیدی پیام
        'text' => "📱 **مدیریت تایید شماره موبایل**\n\nدر این بخش می‌توانید مشخص کنید که آیا دریافت شماره اجباری باشد و چه شماره‌هایی پذیرفته شوند.\n\nوضعیت فعلی در دکمه‌ها مشخص است:",
        'parse_mode' => 'Markdown',
        'reply_markup' => phoneVerificationMenu() // فراخوانی تابع از functions.php
    ]);
}

// ==========================================
//   هندلرهای انتخاب چندگانه دسته‌بندی (NEW)
// ==========================================

// 1. تیک زدن/برداشتن در مرحله افزودن محصول
if (strpos($data, 'toggle_cat_add_') === 0) {
    $cat_id = str_replace('toggle_cat_add_', '', $data);
    
    // دریافت تمپ دیتا
    $stmt = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
    $stmt->execute([$chat_id_cb]);
    $temp = json_decode($stmt->fetchColumn(), true);
    
    if (!isset($temp['selected_cats'])) $temp['selected_cats'] = [];

    // اگر هست حذف کن، اگر نیست اضافه کن
    if (in_array($cat_id, $temp['selected_cats'])) {
        $temp['selected_cats'] = array_diff($temp['selected_cats'], [$cat_id]);
    } else {
        $temp['selected_cats'][] = $cat_id;
    }
    
    // ذخیره
    $db->pdo->prepare("UPDATE users SET temp_data = ? WHERE id = ?")->execute([json_encode($temp), $chat_id_cb]);
    
    // بازسازی کیبورد برای نمایش تیک‌ها
    $cats = $db->pdo->query("SELECT * FROM categories")->fetchAll();
    $keyboard = [];
    foreach($cats as $c) {
        $tick = in_array($c['id'], $temp['selected_cats']) ? "✅ " : "";
        $keyboard[] = [['text' => $tick . $c['name'], 'callback_data' => "toggle_cat_add_" . $c['id']]];
    }
    $keyboard[] = [['text' => '✅ ثبت و ادامه', 'callback_data' => "submit_cat_add"]];
    
    bot('editMessageReplyMarkup', [
        'chat_id' => $chat_id_cb,
        'message_id' => $update->callback_query->message->message_id,
        'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
    ]);
    bot('answerCallbackQuery', ['callback_query_id' => $cq_id]);
}

// 2. ثبت نهایی دسته در مرحله افزودن محصول
elseif ($data == 'submit_cat_add') {
    $stmt = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
    $stmt->execute([$chat_id_cb]);
    $temp = json_decode($stmt->fetchColumn(), true);
    
    if (empty($temp['selected_cats'])) {
        bot('answerCallbackQuery', ['callback_query_id' => $cq_id, 'text' => "⚠️ حداقل یک دسته را انتخاب کنید.", 'show_alert' => true]);
    } else {
        // تغییر مسیر: به جای add_prod_support به add_prod_more_desc می‌رویم
        $db->pdo->prepare("UPDATE users SET step = 'add_prod_more_desc' WHERE id = ?")->execute([$chat_id_cb]);
        
        // حذف پیام شیشه‌ای قبلی
        bot('deleteMessage', ['chat_id' => $chat_id_cb, 'message_id' => $update->callback_query->message->message_id]);
        
        bot('sendMessage', [
            'chat_id' => $chat_id_cb, 
            'text' => "📄 **توضیحات بیشتر (تکمیلی) را وارد کنید:**\n\nشما می‌توانید توضیحات طولانی را در **چند پیام پشت سر هم** ارسال کنید.\nهر پیامی که بفرستید به انتهای متن قبلی اضافه می‌شود.\n\n👇 پس از اینکه تمام توضیحات را فرستادید، دکمه **«✅ پایان و ثبت»** را بزنید.\nاگر توضیحات ندارید، دکمه «ندارم» را بزنید.", 
            'reply_markup' => json_encode([
                'keyboard' => [
                    [['text' => '✅ پایان و ثبت توضیحات']],
                    [['text' => 'ندارم (none)']]
                ], 
                'resize_keyboard' => true
            ])
        ]);
    }


}

// 3. تیک زدن/برداشتن در مرحله ویرایش محصول
elseif (strpos($data, 'toggle_cat_edit_') === 0) {
    $cat_id = str_replace('toggle_cat_edit_', '', $data);
    
    $stmt = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
    $stmt->execute([$chat_id_cb]);
    $temp = json_decode($stmt->fetchColumn(), true);
    
    if (!isset($temp['selected_cats'])) $temp['selected_cats'] = [];

    if (in_array($cat_id, $temp['selected_cats'])) {
        $temp['selected_cats'] = array_diff($temp['selected_cats'], [$cat_id]);
    } else {
        $temp['selected_cats'][] = $cat_id;
    }
    
    $db->pdo->prepare("UPDATE users SET temp_data = ? WHERE id = ?")->execute([json_encode($temp), $chat_id_cb]);
    
    // بازسازی کیبورد
    $cats = $db->pdo->query("SELECT * FROM categories")->fetchAll();
    $keys = [];
    foreach ($cats as $c) {
        $tick = in_array($c['id'], $temp['selected_cats']) ? "✅ " : "";
        $keys[] = [['text' => $tick . $c['name'], 'callback_data' => "toggle_cat_edit_" . $c['id']]];
    }
    $pid = $temp['editing_pid'];
    $keys[] = [['text' => '💾 ذخیره تغییرات', 'callback_data' => "submit_cat_edit"]];
    $keys[] = [['text' => '🔙 بازگشت', 'callback_data' => "modify_select_" . $pid]];
    
    bot('editMessageReplyMarkup', [
        'chat_id' => $chat_id_cb,
        'message_id' => $update->callback_query->message->message_id,
        'reply_markup' => json_encode(['inline_keyboard' => $keys])
    ]);
    bot('answerCallbackQuery', ['callback_query_id' => $cq_id]);
}

// 4. ثبت نهایی ویرایش دسته‌ها
elseif ($data == 'submit_cat_edit') {
    $stmt = $db->pdo->prepare("SELECT temp_data FROM users WHERE id = ?");
    $stmt->execute([$chat_id_cb]);
    $temp = json_decode($stmt->fetchColumn(), true);
    
    $pid = $temp['editing_pid'];
    $new_cats = $temp['selected_cats'] ?? [];
    
    // آپدیت دیتابیس با تابع
    updateProductCategories($pid, $new_cats);
    
    bot('answerCallbackQuery', ['callback_query_id' => $cq_id, 'text' => "✅ دسته‌بندی‌ها بروزرسانی شدند.", 'show_alert' => true]);
    
    // بازگشت به منوی ویرایش
    bot('editMessageText', [
        'chat_id' => $chat_id_cb,
        'message_id' => $update->callback_query->message->message_id,
        'text' => "✅ دسته‌بندی‌ها ذخیره شدند.\nادامه ویرایش:",
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => '✏️ ویرایش مشخصات', 'callback_data' => "modify_select_" . $pid]],
                [['text' => '🔙 بازگشت به لیست', 'callback_data' => "back_to_list"]]
            ]
        ])
    ]);
}


?>
